/*
 * Decompiled with CFR 0.152.
 */
package io.youi.server;

import io.undertow.io.IoCallback;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.resource.DirectoryUtils;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.util.ByteRange;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.Headers;
import io.youi.http.FileContent;
import java.io.File;
import java.util.Date;
import scala.Predef$;
import scala.runtime.BoxedUnit;

public final class ResourceServer$ {
    public static ResourceServer$ MODULE$;
    private final FileResourceManager io$youi$server$ResourceServer$$defaultResourceManager;

    static {
        new ResourceServer$();
    }

    public FileResourceManager io$youi$server$ResourceServer$$defaultResourceManager() {
        return this.io$youi$server$ResourceServer$$defaultResourceManager;
    }

    public void serve(HttpServerExchange exchange, FileContent content) {
        if (DirectoryUtils.sendRequestedBlobs((HttpServerExchange)exchange)) {
            return;
        }
        ResponseCache cache = (ResponseCache)exchange.getAttachment(ResponseCache.ATTACHMENT_KEY);
        boolean cachable = true;
        if (cache != null && cachable && cache.tryServeResponse()) {
            return;
        }
        HttpHandler dispatchTask = new HttpHandler(content){
            private final FileContent content$1;

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String contentType;
                RangeAwareResource rangeAwareResource;
                FileResource resource = new FileResource(this.content$1.file(), ResourceServer$.MODULE$.io$youi$server$ResourceServer$$defaultResourceManager(), this.content$1.file().getAbsolutePath());
                ETag etag = resource.getETag();
                Date lastModified = resource.getLastModified();
                if (!ETagUtils.handleIfMatch((HttpServerExchange)exchange, (ETag)etag, (boolean)false) || !DateUtils.handleIfUnmodifiedSince((HttpServerExchange)exchange, (Date)lastModified)) {
                    exchange.setStatusCode(412);
                    exchange.endExchange();
                    return;
                }
                if (!ETagUtils.handleIfNoneMatch((HttpServerExchange)exchange, (ETag)etag, (boolean)true) || !DateUtils.handleIfModifiedSince((HttpServerExchange)exchange, (Date)lastModified)) {
                    exchange.setStatusCode(304);
                    exchange.endExchange();
                    return;
                }
                long contentLength = Predef$.MODULE$.Long2long(resource.getContentLength());
                Object object = !exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING) ? exchange.setResponseContentLength(contentLength) : BoxedUnit.UNIT;
                ByteRange.RangeResponseResult rangeResponse = null;
                long start = -1L;
                long end = -1L;
                FileResource fileResource = resource;
                if (fileResource instanceof RangeAwareResource && (rangeAwareResource = (RangeAwareResource)fileResource).isRangeSupported()) {
                    BoxedUnit boxedUnit;
                    exchange.getResponseHeaders().put(Headers.ACCEPT_RANGES, "bytes");
                    ByteRange range = ByteRange.parse((String)exchange.getRequestHeaders().getFirst(Headers.RANGE));
                    if (range != null && range.getRanges() == 1 && resource.getContentLength() != null) {
                        rangeResponse = range.getResponseResult(Predef$.MODULE$.Long2long(resource.getContentLength()), exchange.getRequestHeaders().getFirst(Headers.IF_RANGE), resource.getLastModified(), resource.getETag() == null ? null : resource.getETag().getTag());
                        if (rangeResponse != null) {
                            start = rangeResponse.getStart();
                            end = rangeResponse.getEnd();
                            exchange.setStatusCode(rangeResponse.getStatusCode());
                            exchange.getResponseHeaders().put(Headers.CONTENT_RANGE, rangeResponse.getContentRange());
                            long length = rangeResponse.getContentLength();
                            exchange.setResponseContentLength(length);
                            if (rangeResponse.getStatusCode() == 416) {
                                return;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Object object2 = !exchange.getResponseHeaders().contains(Headers.CONTENT_TYPE) ? ((contentType = this.content$1.contentType().mimeType()) != null ? exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType) : exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/octet-stream")) : BoxedUnit.UNIT;
                Object object3 = lastModified != null ? exchange.getResponseHeaders().put(Headers.LAST_MODIFIED, resource.getLastModifiedString()) : BoxedUnit.UNIT;
                if (etag != null) {
                    exchange.getResponseHeaders().put(Headers.ETAG, etag.toString());
                } else if (rangeResponse != null) {
                    ((RangeAwareResource)resource).serveRange(exchange.getResponseSender(), exchange, start, end, IoCallback.END_EXCHANGE);
                } else {
                    resource.serve(exchange.getResponseSender(), exchange, IoCallback.END_EXCHANGE);
                }
            }
            {
                this.content$1 = content$1;
            }
        };
        if (exchange.isInIoThread()) {
            exchange.dispatch(dispatchTask);
        } else {
            dispatchTask.handleRequest(exchange);
        }
    }

    private ResourceServer$() {
        MODULE$ = this;
        this.io$youi$server$ResourceServer$$defaultResourceManager = new FileResourceManager(new File("."));
    }
}

