/*
 * Decompiled with CFR 0.152.
 */
package io.youi.server;

import io.undertow.Handlers;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateHandshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.youi.http.Connection;
import io.youi.http.Content;
import io.youi.http.FileContent;
import io.youi.http.FileEntry;
import io.youi.http.FormData;
import io.youi.http.FormDataContent;
import io.youi.http.Headers;
import io.youi.http.Headers$;
import io.youi.http.HttpConnection;
import io.youi.http.HttpRequest;
import io.youi.http.HttpResponse;
import io.youi.http.Method$;
import io.youi.http.StringContent;
import io.youi.http.StringEntry;
import io.youi.http.URLContent;
import io.youi.net.ContentType;
import io.youi.net.ContentType$;
import io.youi.net.IP;
import io.youi.net.IP$;
import io.youi.net.Parameters;
import io.youi.net.Parameters$;
import io.youi.net.Path;
import io.youi.net.Path$;
import io.youi.net.Protocol;
import io.youi.net.URL;
import io.youi.net.URL$;
import io.youi.server.KeyStore;
import io.youi.server.ResourceServer$;
import io.youi.server.Server;
import io.youi.server.ServerImplementation;
import io.youi.server.ServerImplementationCreator;
import io.youi.server.UndertowServerImplementation;
import io.youi.server.UndertowServerImplementation$;
import io.youi.server.util.SSLUtil$;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.ssl.XnioSsl;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class UndertowServerImplementation$
implements ServerImplementationCreator {
    public static UndertowServerImplementation$ MODULE$;

    static {
        new UndertowServerImplementation$();
    }

    public ServerImplementation create(Server server) {
        return new UndertowServerImplementation(server);
    }

    public Headers parseHeaders(HeaderMap headerMap) {
        return Headers$.MODULE$.apply(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)headerMap).asScala()).map((Function1 & Serializable & scala.Serializable)hv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)hv.getHeaderName().toString()), (Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)hv).asScala()).toList()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public HttpRequest request(HttpServerExchange exchange) {
        None$ none$;
        IP source = IP$.MODULE$.apply(exchange.getSourceAddress().getAddress().getHostAddress());
        Headers headers = this.parseHeaders(exchange.getRequestHeaders());
        if (exchange.getRequestContentLength() > 0L) {
            ContentType contentType = (ContentType)Headers.Content$minusType$.MODULE$.value(headers).getOrElse((Function0 & Serializable & scala.Serializable)() -> ContentType$.MODULE$.text$divplain());
            ContentType contentType2 = ContentType$.MODULE$.multipart$divform$minusdata();
            ContentType contentType3 = contentType;
            if (contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only multipart/form-data is supported currently but received ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contentType})));
            }
            io.undertow.server.handlers.form.FormData formData = (io.undertow.server.handlers.form.FormData)exchange.getAttachment(FormDataParser.FORM_DATA);
            List data = (List)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)formData).asScala()).toList().map((Function1 & Serializable & scala.Serializable)key -> {
                List entries = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)formData.get(key)).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                    Headers headers = MODULE$.parseHeaders(entry.getHeaders());
                    return entry.isFile() ? new FileEntry(entry.getFileName(), entry.getPath().toFile(), headers) : new StringEntry(entry.getValue(), headers);
                }, Iterable$.MODULE$.canBuildFrom())).toList();
                return new FormData(key, entries);
            }, List$.MODULE$.canBuildFrom());
            Some some = new Some((Object)new FormDataContent(data));
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        None$ content = none$;
        return new HttpRequest(Method$.MODULE$.apply(exchange.getRequestMethod().toString()), source, URL$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exchange.getRequestURL(), exchange.getQueryString()}))), headers, (Option)content);
    }

    public void response(UndertowServerImplementation impl, HttpConnection connection, HttpServerExchange exchange) {
        Option option = connection.webSocketSupport();
        if (option instanceof Some) {
            Some some = (Some)option;
            Connection webSocketListener = (Connection)some.value();
            this.handleWebSocket(impl, connection, webSocketListener, exchange);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Option option2 = connection.proxySupport();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                io.youi.http.ProxyHandler proxyHandler = (io.youi.http.ProxyHandler)some.value();
                Option option3 = proxyHandler.proxy(connection);
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    URL destination = (URL)some2.value();
                    this.handleProxy(impl, connection, exchange, destination, (Option<KeyStore>)proxyHandler.keyStore());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option3)) {
                    this.handleStandard(impl, connection, exchange);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option3);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                this.handleStandard(impl, connection, exchange);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void handleWebSocket(UndertowServerImplementation impl, HttpConnection httpConnection, Connection connection, HttpServerExchange exchange) {
        WebSocketProtocolHandshakeHandler handler = Handlers.websocket((WebSocketConnectionCallback)new WebSocketConnectionCallback(connection){
            public final Connection connection$1;

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                this.connection$1.send().text().attach((Function1 & Serializable & scala.Serializable)message -> {
                    anon.2.$anonfun$onConnect$1(channel, message);
                    return BoxedUnit.UNIT;
                }, this.connection$1.send().text().attach$default$2());
                this.connection$1.send().binary().attach((Function1 & Serializable & scala.Serializable)message -> {
                    anon.2.$anonfun$onConnect$2(channel, message);
                    return BoxedUnit.UNIT;
                }, this.connection$1.send().binary().attach$default$2());
                this.connection$1.send().close().attach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    anon.2.$anonfun$onConnect$3(channel, x$1);
                    return BoxedUnit.UNIT;
                }, this.connection$1.send().close().attach$default$2());
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(this){
                    private final /* synthetic */ anon.2 $outer;

                    public void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
                        String data = message.getData();
                        this.$outer.connection$1.receive().text().$colon$eq((Function0 & Serializable & scala.Serializable)() -> data);
                        super.onFullTextMessage(channel, message);
                    }

                    public void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
                        this.$outer.connection$1.receive().binary().$colon$eq((Function0 & Serializable & scala.Serializable)() -> (ByteBuffer[])message.getData().getResource());
                        super.onFullBinaryMessage(channel, message);
                    }

                    public void onError(WebSocketChannel channel, Throwable error) {
                        this.$outer.connection$1.error().$colon$eq((Function0 & Serializable & scala.Serializable)() -> error);
                        super.onError(channel, error);
                    }

                    public void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
                        this.$outer.connection$1.receive().close().$colon$eq((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
                        super.onFullCloseMessage(channel, message);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFullTextMessage$1(java.lang.String ), $anonfun$onFullBinaryMessage$1(io.undertow.websockets.core.BufferedBinaryMessage ), $anonfun$onError$1(java.lang.Throwable ), $anonfun$onFullCloseMessage$1()}, serializedLambda);
                    }
                });
                channel.resumeReceives();
                this.connection$1._connected().$colon$eq((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
            }

            public static final /* synthetic */ void $anonfun$onConnect$1(WebSocketChannel channel$1, String message) {
                WebSockets.sendText((String)message, (WebSocketChannel)channel$1, null);
            }

            public static final /* synthetic */ void $anonfun$onConnect$2(WebSocketChannel channel$1, ByteBuffer[] message) {
                WebSockets.sendBinary((ByteBuffer[])message, (WebSocketChannel)channel$1, null);
            }

            public static final /* synthetic */ void $anonfun$onConnect$3(WebSocketChannel channel$1, BoxedUnit x$1) {
                channel$1.sendClose();
            }
            {
                this.connection$1 = connection$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onConnect$1$adapted(io.undertow.websockets.core.WebSocketChannel java.lang.String ), $anonfun$onConnect$2$adapted(io.undertow.websockets.core.WebSocketChannel java.nio.ByteBuffer[] ), $anonfun$onConnect$3$adapted(io.undertow.websockets.core.WebSocketChannel scala.runtime.BoxedUnit ), $anonfun$onConnect$4()}, serializedLambda);
            }
        });
        Object object = impl.webSocketCompression() ? handler.addExtension((ExtensionHandshake)new PerMessageDeflateHandshake()) : BoxedUnit.UNIT;
        handler.handleRequest(exchange);
    }

    private void handleProxy(UndertowServerImplementation impl, HttpConnection connection, HttpServerExchange exchange, URL destination, Option<KeyStore> keyStore) {
        LoadBalancingProxyClient proxyClient = new LoadBalancingProxyClient();
        Option ssl = keyStore.map((Function1 & Serializable & scala.Serializable)ks -> {
            SSLContext sslContext = SSLUtil$.MODULE$.createSSLContext(ks.location(), ks.password());
            return new UndertowXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, sslContext);
        });
        Path x$2 = Path$.MODULE$.empty();
        Parameters x$3 = Parameters$.MODULE$.empty();
        None$ x$4 = None$.MODULE$;
        Protocol x$5 = destination.copy$default$1();
        String x$6 = destination.copy$default$2();
        int x$7 = destination.copy$default$3();
        URI uri = new URI(destination.copy(x$5, x$6, x$7, x$2, x$3, (Option)x$4).toString());
        proxyClient.addHost(uri, (XnioSsl)ssl.orNull(Predef$.MODULE$.$conforms()));
        ProxyHandler proxyHandler = Handlers.proxyHandler((ProxyClient)proxyClient);
        exchange.setRequestPath(destination.path().encoded());
        exchange.setRequestURI(destination.path().encoded());
        proxyHandler.handleRequest(exchange);
    }

    private void handleStandard(UndertowServerImplementation impl, HttpConnection connection, HttpServerExchange exchange) {
        HttpResponse response = connection.response();
        exchange.setStatusCode(response.status().code());
        response.headers().map().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List values = (List)tuple2._2();
            HeaderMap headerMap = exchange.getResponseHeaders().putAll(new HttpString(key), (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)values).asJava());
            return headerMap;
        });
        String string = exchange.getRequestMethod().toString();
        String string2 = "HEAD";
        if (string == null ? string2 != null : !string.equals(string2)) {
            Option option = response.content();
            if (option instanceof Some) {
                Some some = (Some)option;
                Content content = (Content)some.value();
                Content content2 = content;
                if (content2 instanceof StringContent) {
                    StringContent stringContent = (StringContent)content2;
                    String s = stringContent.value();
                    exchange.getResponseSender().send(s, new IoCallback(impl){
                        private final UndertowServerImplementation impl$1;

                        public void onComplete(HttpServerExchange exchange, Sender sender) {
                            sender.close();
                        }

                        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                            sender.close();
                            this.impl$1.server().error((Throwable)exception);
                        }
                        {
                            this.impl$1 = impl$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (content2 instanceof FileContent) {
                    FileContent fileContent = (FileContent)content2;
                    ResourceServer$.MODULE$.serve(exchange, fileContent);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (content2 instanceof URLContent) {
                    URLContent uRLContent = (URLContent)content2;
                    java.net.URL url = uRLContent.url();
                    URLResource resource = new URLResource(url, "");
                    resource.serve(exchange.getResponseSender(), exchange, new IoCallback(impl){
                        private final UndertowServerImplementation impl$1;

                        public void onComplete(HttpServerExchange exchange, Sender sender) {
                            sender.close();
                        }

                        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                            sender.close();
                            this.impl$1.server().error((Throwable)exception);
                        }
                        {
                            this.impl$1 = impl$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)content2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                exchange.getResponseSender().send("", new IoCallback(impl){
                    private final UndertowServerImplementation impl$1;

                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        sender.close();
                    }

                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        sender.close();
                        this.impl$1.server().error((Throwable)exception);
                    }
                    {
                        this.impl$1 = impl$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private UndertowServerImplementation$() {
        MODULE$ = this;
    }
}

