/*
 * Decompiled with CFR 0.152.
 */
package io.youi.spatial;

import io.youi.spatial.ImmutableMatrix3;
import io.youi.spatial.MathException;
import io.youi.spatial.Matrix3;
import io.youi.spatial.Matrix3$;
import io.youi.spatial.Matrix3$$anonfun$;
import io.youi.spatial.Matrix3ArrayPool$;
import io.youi.spatial.MutableMatrix3;
import io.youi.spatial.Point;
import io.youi.spatial.ops.Matrix3Addition$;
import io.youi.spatial.ops.Matrix3Multiply$;
import io.youi.spatial.ops.Matrix3Subtraction$;
import io.youi.spatial.package$;
import io.youi.spatial.package$DoubleOps$;
import scala.Function1;
import scala.Function9;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxedUnit;

public abstract class Matrix3$class {
    public static Matrix3 duplicate(Matrix3 $this, Matrix3 that) {
        return $this.duplicate(that.m00(), that.m01(), that.m02(), that.m10(), that.m11(), that.m12(), that.m20(), that.m21(), that.m22());
    }

    public static double duplicate$default$1(Matrix3 $this) {
        return $this.m00();
    }

    public static double duplicate$default$2(Matrix3 $this) {
        return $this.m01();
    }

    public static double duplicate$default$3(Matrix3 $this) {
        return $this.m02();
    }

    public static double duplicate$default$4(Matrix3 $this) {
        return $this.m10();
    }

    public static double duplicate$default$5(Matrix3 $this) {
        return $this.m11();
    }

    public static double duplicate$default$6(Matrix3 $this) {
        return $this.m12();
    }

    public static double duplicate$default$7(Matrix3 $this) {
        return $this.m20();
    }

    public static double duplicate$default$8(Matrix3 $this) {
        return $this.m21();
    }

    public static double duplicate$default$9(Matrix3 $this) {
        return $this.m22();
    }

    public static Matrix3 set(Matrix3 $this, Matrix3 that) {
        return $this.set(that.m00(), that.m01(), that.m02(), that.m10(), that.m11(), that.m12(), that.m20(), that.m21(), that.m22());
    }

    public static double set$default$1(Matrix3 $this) {
        return $this.m00();
    }

    public static double set$default$2(Matrix3 $this) {
        return $this.m01();
    }

    public static double set$default$3(Matrix3 $this) {
        return $this.m02();
    }

    public static double set$default$4(Matrix3 $this) {
        return $this.m10();
    }

    public static double set$default$5(Matrix3 $this) {
        return $this.m11();
    }

    public static double set$default$6(Matrix3 $this) {
        return $this.m12();
    }

    public static double set$default$7(Matrix3 $this) {
        return $this.m20();
    }

    public static double set$default$8(Matrix3 $this) {
        return $this.m21();
    }

    public static double set$default$9(Matrix3 $this) {
        return $this.m22();
    }

    public static double[] toArray(Matrix3 $this, double[] array) {
        array[0] = $this.m00();
        array[1] = $this.m01();
        array[2] = $this.m02();
        array[3] = $this.m10();
        array[4] = $this.m11();
        array[5] = $this.m12();
        array[6] = $this.m20();
        array[7] = $this.m21();
        array[8] = $this.m22();
        return array;
    }

    public static Matrix3 fromArray(Matrix3 $this, double[] array) {
        return $this.set(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]);
    }

    public static Matrix3 withArray(Matrix3 $this, boolean duplicate, Function1 f) {
        return (Matrix3)Matrix3ArrayPool$.MODULE$.use(new Serializable($this, duplicate, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;
            private final boolean duplicate$1;
            private final Function1 f$1;

            public final Matrix3 apply(double[] array) {
                this.$outer.toArray(array);
                this.f$1.apply((Object)array);
                return this.duplicate$1 ? this.$outer.duplicate(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]) : this.$outer.set(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.duplicate$1 = duplicate$1;
                this.f$1 = f$1;
            }
        });
    }

    public static Matrix3 $times(Matrix3 $this, Matrix3 that) {
        return Matrix3Multiply$.MODULE$.apply($this, that, (Function9<Object, Object, Object, Object, Object, Object, Object, Object, Object, Matrix3>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;

            public final Matrix3 apply(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                return this.$outer.duplicate(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Matrix3 $plus(Matrix3 $this, Matrix3 that) {
        return Matrix3Addition$.MODULE$.apply($this, that, (Function9<Object, Object, Object, Object, Object, Object, Object, Object, Object, Matrix3>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;

            public final Matrix3 apply(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                return this.$outer.duplicate(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Matrix3 $minus(Matrix3 $this, Matrix3 that) {
        return Matrix3Subtraction$.MODULE$.apply($this, that, (Function9<Object, Object, Object, Object, Object, Object, Object, Object, Object, Matrix3>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;

            public final Matrix3 apply(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                return this.$outer.duplicate(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Matrix3 $times(Matrix3 $this, double scalar) {
        return $this.withArray(true, (Function1<double[], BoxedUnit>)new Serializable($this, scalar){
            public static final long serialVersionUID = 0L;
            public final double scalar$1;

            public final void apply(double[] x$1) {
                Predef$.MODULE$.wrapDoubleArray(x$1).transform((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Matrix3$$anonfun$.times.2 $outer;

                    public final double apply(double x$2) {
                        return this.apply$mcDD$sp(x$2);
                    }

                    public double apply$mcDD$sp(double x$2) {
                        return x$2 * this.$outer.scalar$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.scalar$1 = scalar$1;
            }
        });
    }

    public static Matrix3 $plus(Matrix3 $this, double scalar) {
        return $this.withArray(true, (Function1<double[], BoxedUnit>)new Serializable($this, scalar){
            public static final long serialVersionUID = 0L;
            public final double scalar$2;

            public final void apply(double[] x$3) {
                Predef$.MODULE$.wrapDoubleArray(x$3).transform((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Matrix3$$anonfun$.plus.2 $outer;

                    public final double apply(double x$4) {
                        return this.apply$mcDD$sp(x$4);
                    }

                    public double apply$mcDD$sp(double x$4) {
                        return x$4 + this.$outer.scalar$2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.scalar$2 = scalar$2;
            }
        });
    }

    public static Matrix3 $minus(Matrix3 $this, double scalar) {
        return $this.withArray(true, (Function1<double[], BoxedUnit>)new Serializable($this, scalar){
            public static final long serialVersionUID = 0L;
            public final double scalar$3;

            public final void apply(double[] x$5) {
                Predef$.MODULE$.wrapDoubleArray(x$5).transform((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Matrix3$$anonfun$.minus.2 $outer;

                    public final double apply(double x$6) {
                        return this.apply$mcDD$sp(x$6);
                    }

                    public double apply$mcDD$sp(double x$6) {
                        return x$6 - this.$outer.scalar$3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.scalar$3 = scalar$3;
            }
        });
    }

    public static Matrix3 $div(Matrix3 $this, double scalar) {
        return $this.withArray(true, (Function1<double[], BoxedUnit>)new Serializable($this, scalar){
            public static final long serialVersionUID = 0L;
            public final double scalar$4;

            public final void apply(double[] x$7) {
                Predef$.MODULE$.wrapDoubleArray(x$7).transform((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Matrix3$$anonfun$.div.1 $outer;

                    public final double apply(double x$8) {
                        return this.apply$mcDD$sp(x$8);
                    }

                    public double apply$mcDD$sp(double x$8) {
                        return x$8 / this.$outer.scalar$4;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.scalar$4 = scalar$4;
            }
        });
    }

    public static MutableMatrix3 mutable(Matrix3 $this) {
        return new MutableMatrix3($this.m00(), $this.m01(), $this.m02(), $this.m10(), $this.m11(), $this.m12(), $this.m20(), $this.m21(), $this.m22());
    }

    public static ImmutableMatrix3 immutable(Matrix3 $this) {
        return new ImmutableMatrix3($this.m00(), $this.m01(), $this.m02(), $this.m10(), $this.m11(), $this.m12(), $this.m20(), $this.m21(), $this.m22());
    }

    public static double det(Matrix3 $this) {
        return $this.m00() * $this.m11() * $this.m22() + $this.m01() * $this.m12() * $this.m20() + $this.m02() * $this.m10() * $this.m21() - $this.m00() * $this.m12() * $this.m21() - $this.m01() * $this.m10() * $this.m22() - $this.m02() * $this.m11() * $this.m20();
    }

    public static Matrix3 transpose(Matrix3 $this) {
        double x$9 = $this.m10();
        double x$10 = $this.m20();
        double x$11 = $this.m01();
        double x$12 = $this.m21();
        double x$13 = $this.m02();
        double x$14 = $this.m12();
        double x$15 = $this.set$default$1();
        double x$16 = $this.set$default$5();
        double x$17 = $this.set$default$9();
        return $this.set(x$15, x$9, x$10, x$11, x$16, x$12, x$13, x$14, x$17);
    }

    public static Matrix3 inv(Matrix3 $this) {
        double determinant = $this.det();
        if (determinant == 0.0) {
            throw new MathException("Cannot invert a singular matrix");
        }
        double inverseDet = 1.0 / determinant;
        return $this.set(($this.m11() * $this.m22() - $this.m21() * $this.m12()) * inverseDet, ($this.m21() * $this.m02() - $this.m01() * $this.m22()) * inverseDet, ($this.m01() * $this.m12() - $this.m11() * $this.m02()) * inverseDet, ($this.m20() * $this.m12() - $this.m10() * $this.m22()) * inverseDet, ($this.m00() * $this.m22() - $this.m20() * $this.m02()) * inverseDet, ($this.m10() * $this.m02() - $this.m00() * $this.m12()) * inverseDet, ($this.m10() * $this.m21() - $this.m20() * $this.m11()) * inverseDet, ($this.m20() * $this.m01() - $this.m00() * $this.m21()) * inverseDet, ($this.m00() * $this.m11() - $this.m10() * $this.m01()) * inverseDet);
    }

    public static Option safeInverse(Matrix3 $this) {
        None$ none$;
        double determinant = $this.det();
        if (determinant == 0.0) {
            none$ = None$.MODULE$;
        } else {
            double inverseDet = 1.0 / determinant;
            none$ = new Some((Object)$this.set(($this.m11() * $this.m22() - $this.m21() * $this.m12()) * inverseDet, ($this.m21() * $this.m02() - $this.m01() * $this.m22()) * inverseDet, ($this.m01() * $this.m12() - $this.m11() * $this.m02()) * inverseDet, ($this.m20() * $this.m12() - $this.m10() * $this.m22()) * inverseDet, ($this.m00() * $this.m22() - $this.m20() * $this.m02()) * inverseDet, ($this.m10() * $this.m02() - $this.m00() * $this.m12()) * inverseDet, ($this.m10() * $this.m21() - $this.m20() * $this.m11()) * inverseDet, ($this.m20() * $this.m01() - $this.m00() * $this.m21()) * inverseDet, ($this.m00() * $this.m11() - $this.m10() * $this.m01()) * inverseDet));
        }
        return none$;
    }

    public static Matrix3 toRotation(Matrix3 $this, double value) {
        double radians = value * (Math.PI * 2);
        double cos = scala.math.package$.MODULE$.cos(radians);
        double sin = scala.math.package$.MODULE$.sin(radians);
        double x$18 = cos;
        double x$19 = sin;
        double x$20 = 0.0;
        double x$21 = -sin;
        double x$22 = cos;
        double x$23 = 0.0;
        double x$24 = 0.0;
        double x$25 = 0.0;
        double x$26 = 1.0;
        return $this.set(x$18, x$21, x$24, x$19, x$22, x$25, x$20, x$23, x$26);
    }

    public static Matrix3 toTranslation(Matrix3 $this, double x, double y) {
        return $this.set(1.0, 0.0, x, 0.0, 1.0, y, 0.0, 0.0, 1.0);
    }

    public static Matrix3 toScaling(Matrix3 $this, double scaleX, double scaleY) {
        return $this.set(scaleX, 0.0, 0.0, 0.0, scaleY, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix3 trn(Matrix3 $this, double x, double y) {
        double x$27 = $this.m02() + x;
        double x$28 = $this.m12() + y;
        double x$29 = $this.set$default$1();
        double x$30 = $this.set$default$2();
        double x$31 = $this.set$default$4();
        double x$32 = $this.set$default$5();
        double x$33 = $this.set$default$7();
        double x$34 = $this.set$default$8();
        double x$35 = $this.set$default$9();
        return $this.set(x$29, x$30, x$27, x$31, x$32, x$28, x$33, x$34, x$35);
    }

    public static Matrix3 translate(Matrix3 $this, double x, double y) {
        return Matrix3Multiply$.MODULE$.apply($this, Matrix3$.MODULE$.Identity().toTranslation(x, y), (Function9<Object, Object, Object, Object, Object, Object, Object, Object, Object, Matrix3>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;

            public final Matrix3 apply(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                return this.$outer.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Matrix3 rotate(Matrix3 $this, double value) {
        return Matrix3Multiply$.MODULE$.apply($this, Matrix3$.MODULE$.Identity().toRotation(value), (Function9<Object, Object, Object, Object, Object, Object, Object, Object, Object, Matrix3>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;

            public final Matrix3 apply(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                return this.$outer.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Matrix3 scale(Matrix3 $this, double scaleX, double scaleY) {
        return Matrix3Multiply$.MODULE$.apply($this, Matrix3$.MODULE$.Identity().toScaling(scaleX, scaleY), (Function9<Object, Object, Object, Object, Object, Object, Object, Object, Object, Matrix3>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix3 $outer;

            public final Matrix3 apply(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                return this.$outer.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean $eq$eq(Matrix3 $this, Matrix3 m) {
        return package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m00()), m.m00()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m01()), m.m01()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m02()), m.m02()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m10()), m.m10()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m11()), m.m11()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m12()), m.m12()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m20()), m.m20()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m21()), m.m21()) && package$DoubleOps$.MODULE$.$less$eq$greater$extension(package$.MODULE$.DoubleOps($this.m22()), m.m22());
    }

    public static Point localize(Matrix3 $this, Point point) {
        double x = point.x() * $this.m00() + point.y() * $this.m01() + $this.m02();
        double y = point.x() * $this.m10() + point.y() * $this.m11() + $this.m12();
        return point.set(x, y);
    }

    public static void $init$(Matrix3 $this) {
    }
}

