/*
 * Decompiled with CFR 0.152.
 */
package io.youi.stream;

import io.youi.http.content.Content;
import io.youi.http.content.FileContent;
import io.youi.http.content.StringContent;
import io.youi.http.content.URLContent;
import io.youi.stream.CacheBuilder;
import io.youi.stream.CachedInformation;
import io.youi.stream.HTMLParser;
import io.youi.stream.HTMLParser$;
import io.youi.stream.IO$;
import io.youi.stream.Reader;
import io.youi.stream.StreamableHTML;
import io.youi.stream.Tag;
import io.youi.stream.Writer;
import io.youi.stream.package$;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class HTMLParser$ {
    public static final HTMLParser$ MODULE$ = new HTMLParser$();
    private static final Regex io$youi$stream$HTMLParser$$SelfClosingTagRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)<(\\S+)(.*)/>"));
    private static final Regex io$youi$stream$HTMLParser$$OpenTagRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)<(\\S+)(.*)>"));
    private static final Regex io$youi$stream$HTMLParser$$CloseTagRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)</(\\S+).*>"));
    private static boolean filterAttributes = false;
    private static Set<String> validAttributes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "class", "data-youi", "data-youi-class"}));
    private static final scala.collection.concurrent.Map<File, StreamableHTML> parsers = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();

    public Regex io$youi$stream$HTMLParser$$SelfClosingTagRegex() {
        return io$youi$stream$HTMLParser$$SelfClosingTagRegex;
    }

    public Regex io$youi$stream$HTMLParser$$OpenTagRegex() {
        return io$youi$stream$HTMLParser$$OpenTagRegex;
    }

    public Regex io$youi$stream$HTMLParser$$CloseTagRegex() {
        return io$youi$stream$HTMLParser$$CloseTagRegex;
    }

    public boolean filterAttributes() {
        return filterAttributes;
    }

    public void filterAttributes_$eq(boolean x$1) {
        filterAttributes = x$1;
    }

    public Set<String> validAttributes() {
        return validAttributes;
    }

    public void validAttributes_$eq(Set<String> x$1) {
        validAttributes = x$1;
    }

    private scala.collection.concurrent.Map<File, StreamableHTML> parsers() {
        return parsers;
    }

    public StreamableHTML cache(Content content) {
        StreamableHTML streamableHTML;
        Content content2 = content;
        if (content2 instanceof FileContent) {
            FileContent fileContent = (FileContent)content2;
            File file = fileContent.file();
            streamableHTML = this.cache(file);
        } else if (content2 instanceof URLContent) {
            URLContent uRLContent = (URLContent)content2;
            URL url = uRLContent.url();
            streamableHTML = this.cache(url);
        } else if (content2 instanceof StringContent) {
            StringContent stringContent = (StringContent)content2;
            String value = stringContent.value();
            streamableHTML = this.cache(value);
        } else {
            throw new MatchError((Object)content2);
        }
        return streamableHTML;
    }

    public StreamableHTML cache(File file) {
        return (StreamableHTML)this.parsers().getOrElseUpdate((Object)file, (Function0 & Serializable)() -> MODULE$.apply(file));
    }

    public StreamableHTML cache(URL url) {
        File file = File.createTempFile("htmlparser", "cache");
        file.deleteOnExit();
        IO$.MODULE$.stream((Reader)package$.MODULE$.url2Reader(url), (Writer)package$.MODULE$.file2Writer(file), IO$.MODULE$.stream$default$3(), IO$.MODULE$.stream$default$4(), IO$.MODULE$.stream$default$5());
        return this.cache(file);
    }

    public StreamableHTML cache(String html) {
        File file = File.createTempFile("htmlparser", "cache");
        file.deleteOnExit();
        IO$.MODULE$.stream((Reader)package$.MODULE$.string2Reader(html), (Writer)package$.MODULE$.file2Writer(file), IO$.MODULE$.stream$default$3(), IO$.MODULE$.stream$default$4(), IO$.MODULE$.stream$default$5());
        return this.cache(file);
    }

    public StreamableHTML apply(File file) {
        CacheBuilder cacheBuilder = new CacheBuilder(file){
            private long lastModified;
            private final File file$2;

            private long lastModified() {
                return this.lastModified;
            }

            private void lastModified_$eq(long x$1) {
                this.lastModified = x$1;
            }

            public boolean isStale() {
                return this.lastModified() != this.file$2.lastModified();
            }

            public CachedInformation buildCache() {
                CachedInformation cachedInformation;
                try (FileInputStream input = new FileInputStream(this.file$2);){
                    try {
                        HTMLParser parser = new HTMLParser(input);
                        Set<Tag.Open> tags = parser.parse();
                        ObjectRef byId = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                        ObjectRef byClass = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                        ObjectRef byTag = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                        ObjectRef byAttribute = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                        tags.foreach((Function1 & Serializable)tag -> {
                            anon.1.$anonfun$buildCache$1(byId, byClass, byAttribute, byTag, tag);
                            return BoxedUnit.UNIT;
                        });
                        this.lastModified_$eq(this.file$2.lastModified());
                        cachedInformation = new CachedInformation((Map<String, Tag.Open>)((Map)byId.elem), (Map<String, Set<Tag.Open>>)((Map)byClass.elem), (Map<String, Set<Tag.Open>>)((Map)byTag.elem), (Map<String, Set<Tag.Open>>)((Map)byAttribute.elem));
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(new StringBuilder(14).append("Error parsing ").append(this.file$2.getAbsolutePath()).toString(), throwable);
                    }
                }
                return cachedInformation;
            }

            public static final /* synthetic */ void $anonfun$buildCache$3(ObjectRef byClass$1, Tag.Open tag$1, String className) {
                block0: {
                    String cn = className.trim();
                    if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cn))) break block0;
                    Set classTags = (Set)((Map)byClass$1.elem).getOrElse((Object)cn, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                    classTags = (Set)classTags.$plus((Object)tag$1);
                    byClass$1.elem = (Map)((Map)byClass$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cn), (Object)classTags));
                }
            }

            public static final /* synthetic */ void $anonfun$buildCache$5(ObjectRef byAttribute$1, Tag.Open tag$1, String attributeName) {
                Set attributeNameTags = (Set)((Map)byAttribute$1.elem).getOrElse((Object)attributeName, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                attributeNameTags = (Set)attributeNameTags.$plus((Object)tag$1);
                byAttribute$1.elem = (Map)((Map)byAttribute$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attributeName), (Object)attributeNameTags));
            }

            public static final /* synthetic */ void $anonfun$buildCache$1(ObjectRef byId$1, ObjectRef byClass$1, ObjectRef byAttribute$1, ObjectRef byTag$1, Tag.Open tag) {
                if (tag.attributes().contains((Object)"id")) {
                    byId$1.elem = (Map)((Map)byId$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tag.attributes().apply((Object)"id")), (Object)tag));
                }
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])((String)tag.attributes().getOrElse((Object)"class", (Function0 & Serializable)() -> "")).split(" ")), (Function1 & Serializable)className -> {
                    anon.1.$anonfun$buildCache$3(byClass$1, tag, className);
                    return BoxedUnit.UNIT;
                });
                tag.attributes().keys().foreach((Function1 & Serializable)attributeName -> {
                    anon.1.$anonfun$buildCache$5(byAttribute$1, tag, attributeName);
                    return BoxedUnit.UNIT;
                });
                Set tagsByName = (Set)((Map)byTag$1.elem).getOrElse((Object)tag.tagName(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                tagsByName = (Set)tagsByName.$plus((Object)tag);
                byTag$1.elem = (Map)((Map)byTag$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tag.tagName()), (Object)tagsByName));
            }
            {
                this.file$2 = file$2;
                this.lastModified = 0L;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$buildCache$1$adapted(scala.runtime.ObjectRef scala.runtime.ObjectRef scala.runtime.ObjectRef scala.runtime.ObjectRef io.youi.stream.Tag$Open ), $anonfun$buildCache$2(), $anonfun$buildCache$3$adapted(scala.runtime.ObjectRef io.youi.stream.Tag$Open java.lang.String ), $anonfun$buildCache$4(), $anonfun$buildCache$5$adapted(scala.runtime.ObjectRef io.youi.stream.Tag$Open java.lang.String ), $anonfun$buildCache$6(), $anonfun$buildCache$7()}, serializedLambda);
            }
        };
        return new StreamableHTML(file, cacheBuilder);
    }

    private HTMLParser$() {
    }
}

