package io.youi.drawable

sealed abstract class Composite(val value: String)

object Composite {
  case object SourceOver extends Composite("source-over")
  case object SourceIn extends Composite("source-in")
  case object SourceOut extends Composite("source-out")
  case object SourceAtop extends Composite("source-atop")
  case object DestinationOver extends Composite("destination-over")
  case object DestinationIn extends Composite("destination-in")
  case object DestinationOut extends Composite("destination-out")
  case object DestinationAtop extends Composite("destination-atop")
  case object Lighter extends Composite("lighter")
  case object Copy extends Composite("copy")
  case object Xor extends Composite("xor")
  case object Multiply extends Composite("multiply")
  case object Screen extends Composite("screen")
  case object Overlay extends Composite("overlay")
  case object Darken extends Composite("darken")
  case object Lighten extends Composite("lighten")
  case object ColorDodge extends Composite("color-dodge")
  case object ColorBurn extends Composite("color-burn")
  case object HardLight extends Composite("hard-light")
  case object SoftLight extends Composite("soft-light")
  case object Difference extends Composite("difference")
  case object Exclusion extends Composite("exclusion")
  case object Hue extends Composite("hue")
  case object Saturation extends Composite("saturation")
  case object Color extends Composite("color")
  case object Luminosity extends Composite("luminosity")
}