/*
 * Decompiled with CFR 0.152.
 */
package io.youi.drawable.stats;

import io.youi.drawable.Context;
import io.youi.drawable.Drawable;
import java.io.Serializable;
import reactify.Val;
import reactify.Var;
import reactify.Var$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0012%\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0001\r\u0011\"\u0003@\u0011\u001d\u0019\u0005\u00011A\u0005\n\u0011CaA\u0013\u0001!B\u0013\u0001\u0005bB&\u0001\u0001\u0004%Ia\u0010\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0011\u0019y\u0005\u0001)Q\u0005\u0001\"9\u0001\u000b\u0001a\u0001\n\u0013y\u0004bB)\u0001\u0001\u0004%IA\u0015\u0005\u0007)\u0002\u0001\u000b\u0015\u0002!\t\u000fU\u0003\u0001\u0019!C\u0005\u007f!9a\u000b\u0001a\u0001\n\u00139\u0006BB-\u0001A\u0003&\u0001\tC\u0004[\u0001\t\u0007I\u0011B.\t\r\t\u0004\u0001\u0015!\u0003]\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011Dq\u0001\u001b\u0001A\u0002\u0013%\u0011\u000e\u0003\u0004l\u0001\u0001\u0006K!\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019\t\b\u0001)A\u0005]\"9!\u000f\u0001a\u0001\n\u0013I\u0004bB:\u0001\u0001\u0004%I\u0001\u001e\u0005\u0007m\u0002\u0001\u000b\u0015\u0002\u001e\t\u000b]\u0004A\u0011\u0001=\t\r\u0005=\u0001\u0001\"\u0001e\u0011\u0019\t\t\u0002\u0001C\u0001I\"1\u00111\u0003\u0001\u0005\u0002\u0011Dq!!\u0006\u0001\t\u0003\t9\u0002\u0003\u0004\u0002 \u0001!\t\u0001\u001a\u0005\u0007\u0003C\u0001A\u0011A\u001d\t\r\u0005\r\u0002\u0001\"\u0001:\u0011\u001d\t)\u0003\u0001C!\u0003O\u00111BU3oI\u0016\u00148\u000b^1ug*\u0011QEJ\u0001\u0006gR\fGo\u001d\u0006\u0003O!\n\u0001\u0002\u001a:bo\u0006\u0014G.\u001a\u0006\u0003S)\nA!_8vS*\t1&\u0001\u0002j_\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u000e\t\u0003o\u0001i\u0011\u0001J\u0001\bg\u0006l\u0007\u000f\\3t+\u0005Q\u0004CA\u0018<\u0013\ta\u0004GA\u0002J]R\f\u0001b]1na2,7\u000fI\u0001\fM&\u00148\u000f\u001e*f]\u0012,'/F\u0001A!\ty\u0013)\u0003\u0002Ca\t!Aj\u001c8h\u0003=1\u0017N]:u%\u0016tG-\u001a:`I\u0015\fHCA#I!\tyc)\u0003\u0002Ha\t!QK\\5u\u0011\u001dIU!!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u000311\u0017N]:u%\u0016tG-\u001a:!\u0003)a\u0017m\u001d;SK:$WM]\u0001\u000fY\u0006\u001cHOU3oI\u0016\u0014x\fJ3r)\t)e\nC\u0004J\u0011\u0005\u0005\t\u0019\u0001!\u0002\u00171\f7\u000f\u001e*f]\u0012,'\u000fI\u0001\fe\u0016tG-\u001a:Ti\u0006\u0014H/A\bsK:$WM]*uCJ$x\fJ3r)\t)5\u000bC\u0004J\u0017\u0005\u0005\t\u0019\u0001!\u0002\u0019I,g\u000eZ3s'R\f'\u000f\u001e\u0011\u0002\u0019I,g\u000eZ3s\r&t\u0017n\u001d5\u0002!I,g\u000eZ3s\r&t\u0017n\u001d5`I\u0015\fHCA#Y\u0011\u001dIe\"!AA\u0002\u0001\u000bQB]3oI\u0016\u0014h)\u001b8jg\"\u0004\u0013!B2pk:$X#\u0001/\u0011\u0007u\u0003\u0007)D\u0001_\u0015\u0005y\u0016\u0001\u0003:fC\u000e$\u0018NZ=\n\u0005\u0005t&a\u0001,be\u000611m\\;oi\u0002\n1\u0002\\1ti\u0016c\u0017\r]:fIV\tQ\r\u0005\u00020M&\u0011q\r\r\u0002\u0007\t>,(\r\\3\u0002\u001f1\f7\u000f^#mCB\u001cX\rZ0%KF$\"!\u00126\t\u000f%\u001b\u0012\u0011!a\u0001K\u0006aA.Y:u\u000b2\f\u0007o]3eA\u00059Q\r\\1qg\u0016$W#\u00018\u0011\u0007=zW-\u0003\u0002qa\t)\u0011I\u001d:bs\u0006AQ\r\\1qg\u0016$\u0007%\u0001\u0005q_NLG/[8o\u00031\u0001xn]5uS>tw\fJ3r)\t)U\u000fC\u0004J1\u0005\u0005\t\u0019\u0001\u001e\u0002\u0013A|7/\u001b;j_:\u0004\u0013\u0001\u00023sC^$r!R=\u007f\u0003\u000f\tY\u0001C\u0003(5\u0001\u0007!\u0010\u0005\u0002|y6\ta%\u0003\u0002~M\tAAI]1xC\ndW\r\u0003\u0004\u00005\u0001\u0007\u0011\u0011A\u0001\bG>tG/\u001a=u!\rY\u00181A\u0005\u0004\u0003\u000b1#aB\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0013Q\u0002\u0019A3\u0002\u0003aDa!!\u0004\u001b\u0001\u0004)\u0017!A=\u0002\u000f\u00054XM]1hK\u0006\u0019Q.\u001b8\u0002\u00075\f\u00070A\u0004sK:$WM]:\u0016\u0005\u0005e\u0001\u0003B/\u0002\u001c\u0001K1!!\b_\u0005\r1\u0016\r\\\u0001\bGV\u0014(/\u001a8u\u0003\r1\u0007o]\u0001\u000bCZ,'/Y4f\rB\u001b\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0002\u0003BA\u0016\u0003sqA!!\f\u00026A\u0019\u0011q\u0006\u0019\u000e\u0005\u0005E\"bAA\u001aY\u00051AH]8pizJ1!a\u000e1\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0007\u0019")
public class RenderStats {
    private final int samples;
    private long firstRender = 0L;
    private long lastRender = 0L;
    private long renderStart = 0L;
    private long renderFinish = 0L;
    private final Var<Object> count = Var$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, Var$.MODULE$.apply$default$2(), Var$.MODULE$.apply$default$3());
    private double lastElapsed = 0.0;
    private final double[] elapsed = new double[this.samples()];
    private int position = 0;

    private int samples() {
        return this.samples;
    }

    private long firstRender() {
        return this.firstRender;
    }

    private void firstRender_$eq(long x$1) {
        this.firstRender = x$1;
    }

    private long lastRender() {
        return this.lastRender;
    }

    private void lastRender_$eq(long x$1) {
        this.lastRender = x$1;
    }

    private long renderStart() {
        return this.renderStart;
    }

    private void renderStart_$eq(long x$1) {
        this.renderStart = x$1;
    }

    private long renderFinish() {
        return this.renderFinish;
    }

    private void renderFinish_$eq(long x$1) {
        this.renderFinish = x$1;
    }

    private Var<Object> count() {
        return this.count;
    }

    private double lastElapsed() {
        return this.lastElapsed;
    }

    private void lastElapsed_$eq(double x$1) {
        this.lastElapsed = x$1;
    }

    private double[] elapsed() {
        return this.elapsed;
    }

    private int position() {
        return this.position;
    }

    private void position_$eq(int x$1) {
        this.position = x$1;
    }

    public void draw(Drawable drawable, Context context, double x, double y) {
        double elapsed;
        long start = System.nanoTime();
        drawable.draw(context, x, y);
        long finished = System.nanoTime();
        this.elapsed()[this.position()] = elapsed = (double)(finished - start) / 1.0E9;
        this.position_$eq(this.position() + 1);
        if (this.position() == this.samples()) {
            this.position_$eq(0);
        }
        if (this.firstRender() == 0L) {
            this.firstRender_$eq(finished);
        }
        this.lastRender_$eq(finished);
        this.renderStart_$eq(start);
        this.renderFinish_$eq(finished);
        this.count().static((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)reactify.package$.MODULE$.val2Value(this.count())) + 1L)));
        this.lastElapsed_$eq(elapsed);
    }

    public double average() {
        DoubleRef count = DoubleRef.create((double)0.0);
        DoubleRef sum = DoubleRef.create((double)0.0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.elapsed())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)e -> {
            block0: {
                if (e == -1.0) break block0;
                sum$1.elem += e;
                count$1.elem += 1.0;
            }
        });
        return sum.elem / count.elem;
    }

    public double min() {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.elapsed())).foldLeft((Object)BoxesRunTime.boxToDouble((double)1000.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(min, current) -> current != -1.0 ? package$.MODULE$.min(min, current) : min));
    }

    public double max() {
        double d = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.elapsed())).max((Ordering)Ordering.Double$.MODULE$));
        double d2 = -1.0 == d ? 0.0 : d;
        return d2;
    }

    public Val<Object> renders() {
        return this.count();
    }

    public double current() {
        return this.lastElapsed();
    }

    public int fps() {
        return (int)package$.MODULE$.round(1.0 / this.current());
    }

    public int averageFPS() {
        return (int)package$.MODULE$.round(1.0 / this.average());
    }

    public String toString() {
        Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)this.fps());
        double arg$macro$2 = this.current();
        Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)this.averageFPS());
        double arg$macro$4 = this.average();
        double arg$macro$5 = this.min();
        double arg$macro$6 = this.max();
        Object arg$macro$7 = this.renders().apply();
        return new StringOps("Current: %s fps (%2.2f), Average: %s (%2.2f), Min: %2.2f, Max: %2.2f, Renders: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2), arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4), BoxesRunTime.boxToDouble((double)arg$macro$5), BoxesRunTime.boxToDouble((double)arg$macro$6), arg$macro$7}));
    }

    public RenderStats() {
        this.samples = 1000;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.samples()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            $this.elapsed()[index] = -1.0;
        });
    }
}

