/*
 * Decompiled with CFR 0.152.
 */
package io.youi.util;

import io.youi.SingleThreadedFuture;
import io.youi.SingleThreadedFuture$;
import io.youi.dom$;
import io.youi.image.Image;
import io.youi.image.Image$;
import io.youi.image.resize.ImageResizer;
import io.youi.package$;
import io.youi.util.CanvasPool$;
import io.youi.util.FileUtility$;
import io.youi.util.Scaled;
import io.youi.util.SizeUtility$;
import io.youi.video.Video$;
import java.io.Serializable;
import org.scalajs.dom.raw.CanvasRenderingContext2D;
import org.scalajs.dom.raw.Event;
import org.scalajs.dom.raw.File;
import org.scalajs.dom.raw.HTMLCanvasElement;
import org.scalajs.dom.raw.HTMLElement;
import org.scalajs.dom.raw.HTMLImageElement;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.scalajs.js.;
import scala.scalajs.js.Any;
import scala.scalajs.js.Function1;
import scala.util.Try;

public final class ImageUtility$ {
    public static ImageUtility$ MODULE$;
    private final HTMLImageElement tempImage;
    private final SingleThreadedFuture loadImageFuture;

    static {
        new ImageUtility$();
    }

    public Future<HTMLCanvasElement> drawToCanvas(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer, double offsetX, double offsetY, double width, double height) {
        return CanvasPool$.MODULE$.withCanvasFuture(width, height, CanvasPool$.MODULE$.withCanvasFuture$default$3(), (scala.Function1 & Serializable & scala.Serializable)canvas -> resizer.resize(source, (HTMLCanvasElement)canvas).map((scala.Function1 & Serializable & scala.Serializable)x$1 -> {
            CanvasRenderingContext2D qual$1 = package$.MODULE$.ExtendedCanvas(destination).context();
            HTMLCanvasElement x$12 = canvas;
            double x$2 = offsetX;
            double x$3 = offsetY;
            double x$4 = width;
            double x$5 = height;
            double x$6 = qual$1.drawImage$default$6();
            double x$7 = qual$1.drawImage$default$7();
            double x$8 = qual$1.drawImage$default$8();
            double x$9 = qual$1.drawImage$default$9();
            qual$1.drawImage((HTMLElement)x$12, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
            return destination;
        }, ExecutionContext.Implicits$.MODULE$.global()));
    }

    public double drawToCanvas$default$4(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return 0.0;
    }

    public double drawToCanvas$default$5(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return 0.0;
    }

    public double drawToCanvas$default$6(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return ((HTMLImageElement)source).width();
    }

    public double drawToCanvas$default$7(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return ((HTMLImageElement)source).height();
    }

    public Future<HTMLImageElement> resizeToImage(.bar<HTMLImageElement, HTMLCanvasElement> source, double width, double height, HTMLImageElement destination, ImageResizer resizer) {
        return this.resizeToDataURL(source, width, height, resizer).map((scala.Function1 & Serializable & scala.Serializable)dataURL -> {
            destination.src_$eq(dataURL);
            return destination;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<String> resizeToDataURL(.bar<HTMLImageElement, HTMLCanvasElement> source, double width, double height, ImageResizer resizer) {
        HTMLCanvasElement destinationCanvas = CanvasPool$.MODULE$.apply(width, height, CanvasPool$.MODULE$.apply$default$3());
        Future loader = ((HTMLImageElement)source).width() == 0 || ((HTMLImageElement)source).height() == 0 ? this.loadImage((HTMLImageElement)source) : Future$.MODULE$.successful((Object)((HTMLImageElement)source));
        Future future = loader.flatMap((scala.Function1 & Serializable & scala.Serializable)x$2 -> {
            .bar x$1 = source;
            HTMLCanvasElement x$22 = destinationCanvas;
            ImageResizer x$32 = resizer;
            double x$4 = destinationCanvas.width();
            double x$5 = destinationCanvas.height();
            double x$6 = MODULE$.drawToCanvas$default$4((.bar<HTMLImageElement, HTMLCanvasElement>)x$1, x$22, x$32);
            double x$7 = MODULE$.drawToCanvas$default$5((.bar<HTMLImageElement, HTMLCanvasElement>)x$1, x$22, x$32);
            return MODULE$.drawToCanvas((.bar<HTMLImageElement, HTMLCanvasElement>)x$1, x$22, x$32, x$6, x$7, x$4, x$5).map((scala.Function1 & Serializable & scala.Serializable)x$3 -> destinationCanvas.toDataURL("image/png", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Any[0])), ExecutionContext.Implicits$.MODULE$.global());
        }, ExecutionContext.Implicits$.MODULE$.global());
        future.onComplete((scala.Function1 & Serializable & scala.Serializable)x$4 -> {
            CanvasPool$.MODULE$.restore(destinationCanvas);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return future;
    }

    private HTMLImageElement tempImage() {
        return this.tempImage;
    }

    private SingleThreadedFuture loadImageFuture() {
        return this.loadImageFuture;
    }

    public <R> Future<R> loadImage(File file, scala.Function1<HTMLImageElement, Future<R>> process) {
        return this.loadImageFuture().apply((Function0 & Serializable & scala.Serializable)() -> {
            Promise promise = Promise$.MODULE$.apply();
            Function1<Event, Promise<BoxedUnit>> listener = new Function1<Event, Promise<BoxedUnit>>(promise){
                private final Promise promise$1;

                public final Promise<BoxedUnit> apply(Event arg1) {
                    return ImageUtility$.io$youi$util$ImageUtility$$$anonfun$loadImage$2(arg1, this.promise$1);
                }
                {
                    this.promise$1 = promise$1;
                    super((Seq)Nil$.MODULE$);
                }
            };
            MODULE$.tempImage().addEventListener("load", (Function1)listener, MODULE$.tempImage().addEventListener$default$3());
            FileUtility$.MODULE$.loadDataURL(file, FileUtility$.MODULE$.loadDataURL$default$2()).foreach((scala.Function1 & Serializable & scala.Serializable)x$6 -> {
                ImageUtility$.$anonfun$loadImage$3(x$6);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
            return promise.future().flatMap(arg_0 -> ImageUtility$.$anonfun$loadImage$4((Function1)listener, process, arg_0), ExecutionContext.Implicits$.MODULE$.global());
        });
    }

    public Future<HTMLImageElement> loadImage(HTMLImageElement img) {
        Future future;
        if (img.width() > 0 && img.height() > 0) {
            future = Future$.MODULE$.successful((Object)img);
        } else {
            Promise promise = Promise$.MODULE$.apply();
            Function1<Event, Promise<HTMLImageElement>> listener = new Function1<Event, Promise<HTMLImageElement>>(promise, img){
                private final Promise promise$2;
                private final HTMLImageElement img$1;

                public final Promise<HTMLImageElement> apply(Event arg1) {
                    return ImageUtility$.io$youi$util$ImageUtility$$$anonfun$loadImage$6(arg1, this.promise$2, this.img$1);
                }
                {
                    this.promise$2 = promise$2;
                    this.img$1 = img$1;
                    super((Seq)Nil$.MODULE$);
                }
            };
            img.addEventListener("load", (Function1)listener, img.addEventListener$default$3());
            Future future2 = promise.future();
            future2.onComplete(arg_0 -> ImageUtility$.$anonfun$loadImage$7$adapted(img, (Function1)listener, arg_0), ExecutionContext.Implicits$.MODULE$.global());
            future = future2;
        }
        return future;
    }

    public Future<String> toDataURL(HTMLImageElement img) {
        return this.loadImage(img).map((scala.Function1 & Serializable & scala.Serializable)x$11 -> (String)CanvasPool$.MODULE$.withCanvas(img.width(), img.height(), CanvasPool$.MODULE$.withCanvas$default$3(), (scala.Function1 & Serializable & scala.Serializable)canvas -> {
            CanvasRenderingContext2D ctx = (CanvasRenderingContext2D)canvas.getContext("2d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Any[0]));
            ctx.drawImage((HTMLElement)img, 0.0, 0.0, ctx.drawImage$default$4(), ctx.drawImage$default$5(), ctx.drawImage$default$6(), ctx.drawImage$default$7(), ctx.drawImage$default$8(), ctx.drawImage$default$9());
            return canvas.toDataURL("image/png", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Any[0]));
        }), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Option<Image>> preview(File file) {
        return Video$.MODULE$.isVideo(file) ? Video$.MODULE$.apply(file, false, false, true).flatMap((scala.Function1 & Serializable & scala.Serializable)video -> video.seek(video.duration() / 2.0).map((scala.Function1 & Serializable & scala.Serializable)x$12 -> {
            Image image = video.createImage();
            video.dispose();
            return new Some((Object)image);
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global()) : (Image$.MODULE$.isImage(file) ? Image$.MODULE$.apply(file).map((scala.Function1 & Serializable & scala.Serializable)value -> new Some(value), ExecutionContext.Implicits$.MODULE$.global()) : Future$.MODULE$.successful((Object)None$.MODULE$));
    }

    public Future<Option<Image>> preview(File file, double width, double height, boolean scaleUp) {
        return this.preview(file).flatMap((scala.Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Image image = (Image)some.value();
                Scaled scaled = SizeUtility$.MODULE$.scale(image.width(), image.height(), width, height, scaleUp);
                future = image.resize(scaled.width(), scaled.height()).map((scala.Function1 & Serializable & scala.Serializable)resized -> {
                    image.dispose();
                    return new Some(resized);
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Option<String>> generatePreview(File file, double width, double height, boolean scaleUp) {
        return this.preview(file, width, height, scaleUp).flatMap((scala.Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Image image = (Image)some.value();
                future = image.toDataURL().map((scala.Function1 & Serializable & scala.Serializable)value -> new Some(value), ExecutionContext.Implicits$.MODULE$.global());
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public boolean generatePreview$default$4() {
        return false;
    }

    public static final /* synthetic */ Promise io$youi$util$ImageUtility$$$anonfun$loadImage$2(Event x$5, Promise promise$1) {
        return promise$1.success((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$loadImage$3(String x$6) {
        MODULE$.tempImage().src_$eq(x$6);
    }

    public static final /* synthetic */ void $anonfun$loadImage$5(Try x$8) {
        MODULE$.tempImage().src_$eq("");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Future $anonfun$loadImage$4(Function1 listener$1, scala.Function1 process$1, BoxedUnit x$7) {
        void var3_3;
        MODULE$.tempImage().removeEventListener("load", listener$1, MODULE$.tempImage().removeEventListener$default$3());
        Future f = (Future)process$1.apply((Object)MODULE$.tempImage());
        f.onComplete((scala.Function1 & Serializable & scala.Serializable)x$8 -> {
            ImageUtility$.$anonfun$loadImage$5(x$8);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return var3_3;
    }

    public static final /* synthetic */ Promise io$youi$util$ImageUtility$$$anonfun$loadImage$6(Event x$9, Promise promise$2, HTMLImageElement img$1) {
        return promise$2.success((Object)img$1);
    }

    private ImageUtility$() {
        MODULE$ = this;
        this.tempImage = (HTMLImageElement)dom$.MODULE$.create("img");
        this.loadImageFuture = new SingleThreadedFuture(SingleThreadedFuture$.MODULE$.$lessinit$greater$default$1());
    }

    public static final /* synthetic */ Object $anonfun$loadImage$7$adapted(HTMLImageElement img$1, Function1 listener$2, Try x$10) {
        img$1.removeEventListener("load", listener$2, img$1.removeEventListener$default$3());
        return BoxedUnit.UNIT;
    }
}

