/*
 * Decompiled with CFR 0.152.
 */
package io.youi.image;

import com.outr.CanvgOptions;
import com.outr.canvg$;
import io.youi.dom$;
import io.youi.image.SVGImage;
import io.youi.image.SVGImage$ViewBox$;
import io.youi.net.URL;
import io.youi.path.Path;
import io.youi.path.Path$;
import io.youi.spatial.BoundingBox;
import io.youi.spatial.BoundingBox$;
import io.youi.spatial.ImmutableBoundingBox;
import io.youi.spatial.Size;
import io.youi.stream.StreamURL$;
import io.youi.util.CanvasPool$;
import java.io.Serializable;
import org.scalajs.dom.raw.DOMList;
import org.scalajs.dom.raw.Element;
import org.scalajs.dom.raw.HTMLCanvasElement;
import org.scalajs.dom.raw.HTMLDivElement;
import org.scalajs.dom.raw.SVGCircleElement;
import org.scalajs.dom.raw.SVGEllipseElement;
import org.scalajs.dom.raw.SVGGElement;
import org.scalajs.dom.raw.SVGImageElement;
import org.scalajs.dom.raw.SVGLength$;
import org.scalajs.dom.raw.SVGLinearGradientElement;
import org.scalajs.dom.raw.SVGPathElement;
import org.scalajs.dom.raw.SVGPoint;
import org.scalajs.dom.raw.SVGPolygonElement;
import org.scalajs.dom.raw.SVGRectElement;
import org.scalajs.dom.raw.SVGSVGElement;
import org.scalajs.dom.raw.SVGStyleElement;
import org.scalajs.dom.raw.SVGTransform;
import org.scalajs.dom.raw.SVGTransform$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.scalajs.js.;
import scala.scalajs.js.$bar$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Function;
import scala.scalajs.js.Function0;
import scala.scalajs.js.UndefOr;
import scala.scalajs.js.UndefOr$;
import scribe.Level;
import scribe.LogRecord;
import scribe.LogRecord$;
import scribe.package$;

public final class SVGImage$ {
    public static SVGImage$ MODULE$;

    static {
        new SVGImage$();
    }

    public Future<SVGImage> apply(URL url) {
        Future stream = StreamURL$.MODULE$.stream(url, StreamURL$.MODULE$.stream$default$2(), StreamURL$.MODULE$.stream$default$3(), StreamURL$.MODULE$.stream$default$4(), StreamURL$.MODULE$.stream$default$5(), StreamURL$.MODULE$.stream$default$6());
        return stream.flatMap((Function1 & Serializable & scala.Serializable)svgString -> MODULE$.apply((String)svgString), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<SVGImage> apply(String svgString) {
        Future<SVGImage> future;
        try {
            HTMLDivElement div = (HTMLDivElement)dom$.MODULE$.create("div");
            div.innerHTML_$eq(svgString);
            SVGSVGElement svg = (SVGSVGElement)dom$.MODULE$.ElementExtras((Element)div).oneByTag("svg");
            future = this.apply(svg);
        }
        catch (Throwable t) {
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (scala.Function0 & Serializable & scala.Serializable)() -> t, LogRecord.Stringify$.MODULE$.Default(), "io.youi.image.SVGImage", (Option)new Some((Object)"apply"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)61)), LogRecord$.MODULE$.apply$default$8(), LogRecord$.MODULE$.apply$default$9()));
            throw t;
        }
        return future;
    }

    public Future<SVGImage> apply(SVGSVGElement svg) {
        Size size = this.measure(svg, this.measure$default$2(), this.measure$default$3()).toSize();
        return this.apply(svg, size.width(), size.height());
    }

    public Future<SVGImage> apply(SVGSVGElement svg, double width, double height) {
        Size size = this.measure(svg, this.measure$default$2(), this.measure$default$3()).toSize();
        HTMLCanvasElement canvas = CanvasPool$.MODULE$.apply(width, height, CanvasPool$.MODULE$.apply$default$3());
        return this.drawToCanvas(canvas, svg, 0.0, 0.0, width, height).map((Function1 & Serializable & scala.Serializable)x$4 -> new SVGImage(svg, canvas, size), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> drawToCanvas(HTMLCanvasElement canvas, SVGSVGElement svg, double x, double y, double width, double height) {
        Promise promise = Promise$.MODULE$.apply();
        Function callback = (Function)Any$.MODULE$.fromFunction0((scala.Function0 & Serializable & scala.Serializable)() -> promise.success((Object)BoxedUnit.UNIT));
        canvg$.MODULE$.apply($bar$.MODULE$.from((Object)canvas, .bar.Evidence$.MODULE$.right(.bar.Evidence$.MODULE$.base())), svg.outerHTML(), new CanvgOptions(x, y, width, height, callback){
            private UndefOr<Object> log;
            private UndefOr<Object> ignoreMouse;
            private UndefOr<Object> ignoreAnimation;
            private UndefOr<Object> ignoreDimensions;
            private UndefOr<Object> ignoreClear;
            private UndefOr<Object> offsetX;
            private UndefOr<Object> offsetY;
            private UndefOr<Object> scaleWidth;
            private UndefOr<Object> scaleHeight;
            private UndefOr<Function> renderCallback;
            private UndefOr<Function0<Object>> forceRedraw;
            private UndefOr<Object> useCORS;

            public UndefOr<Object> log() {
                return this.log;
            }

            public void log_$eq(UndefOr<Object> x$1) {
                this.log = x$1;
            }

            public UndefOr<Object> ignoreMouse() {
                return this.ignoreMouse;
            }

            public void ignoreMouse_$eq(UndefOr<Object> x$1) {
                this.ignoreMouse = x$1;
            }

            public UndefOr<Object> ignoreAnimation() {
                return this.ignoreAnimation;
            }

            public void ignoreAnimation_$eq(UndefOr<Object> x$1) {
                this.ignoreAnimation = x$1;
            }

            public UndefOr<Object> ignoreDimensions() {
                return this.ignoreDimensions;
            }

            public void ignoreDimensions_$eq(UndefOr<Object> x$1) {
                this.ignoreDimensions = x$1;
            }

            public UndefOr<Object> ignoreClear() {
                return this.ignoreClear;
            }

            public void ignoreClear_$eq(UndefOr<Object> x$1) {
                this.ignoreClear = x$1;
            }

            public UndefOr<Object> offsetX() {
                return this.offsetX;
            }

            public void offsetX_$eq(UndefOr<Object> x$1) {
                this.offsetX = x$1;
            }

            public UndefOr<Object> offsetY() {
                return this.offsetY;
            }

            public void offsetY_$eq(UndefOr<Object> x$1) {
                this.offsetY = x$1;
            }

            public UndefOr<Object> scaleWidth() {
                return this.scaleWidth;
            }

            public void scaleWidth_$eq(UndefOr<Object> x$1) {
                this.scaleWidth = x$1;
            }

            public UndefOr<Object> scaleHeight() {
                return this.scaleHeight;
            }

            public void scaleHeight_$eq(UndefOr<Object> x$1) {
                this.scaleHeight = x$1;
            }

            public UndefOr<Function> renderCallback() {
                return this.renderCallback;
            }

            public void renderCallback_$eq(UndefOr<Function> x$1) {
                this.renderCallback = x$1;
            }

            public UndefOr<Function0<Object>> forceRedraw() {
                return this.forceRedraw;
            }

            public void forceRedraw_$eq(UndefOr<Function0<Object>> x$1) {
                this.forceRedraw = x$1;
            }

            public UndefOr<Object> useCORS() {
                return this.useCORS;
            }

            public void useCORS_$eq(UndefOr<Object> x$1) {
                this.useCORS = x$1;
            }
            {
                CanvgOptions.$init$((CanvgOptions)this);
                this.ignoreMouse_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.ignoreAnimation_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.ignoreDimensions_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.ignoreClear_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.offsetX_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToInteger((int)((int)scala.math.package$.MODULE$.round(x$5)))));
                this.offsetY_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToInteger((int)((int)scala.math.package$.MODULE$.round(y$1)))));
                this.scaleWidth_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToInteger((int)((int)scala.math.package$.MODULE$.ceil(width$1)))));
                this.scaleHeight_$eq((UndefOr<Object>)UndefOr$.MODULE$.any2undefOrA((Object)BoxesRunTime.boxToInteger((int)((int)scala.math.package$.MODULE$.ceil(height$1)))));
                this.renderCallback_$eq((UndefOr<Function>)UndefOr$.MODULE$.any2undefOrA((Object)callback$1));
            }
        });
        return promise.future();
    }

    public BoundingBox measure(SVGSVGElement svg, boolean applyDimension, boolean force) {
        ImmutableBoundingBox bb;
        block2: {
            ImmutableBoundingBox immutableBoundingBox;
            Some definedHeight;
            Some definedWidth;
            SVGImage.ViewBox viewBox;
            SVGImage.ViewBox viewBox2 = viewBox = svg.viewBox() != null && svg.viewBox().animVal() != null ? new SVGImage.ViewBox(svg.viewBox().animVal().width(), svg.viewBox().animVal().height()) : new SVGImage.ViewBox(SVGImage$ViewBox$.MODULE$.apply$default$1(), SVGImage$ViewBox$.MODULE$.apply$default$2());
            Object object = svg.width().animVal().unitType() == SVGLength$.MODULE$.SVG_LENGTHTYPE_NUMBER() ? new Some((Object)BoxesRunTime.boxToDouble((double)svg.width().animVal().value())) : (definedWidth = viewBox.width() > 0.0 ? new Some((Object)BoxesRunTime.boxToDouble((double)viewBox.width())) : None$.MODULE$);
            Object object2 = svg.height().animVal().unitType() == SVGLength$.MODULE$.SVG_LENGTHTYPE_NUMBER() ? new Some((Object)BoxesRunTime.boxToDouble((double)svg.height().animVal().value())) : (definedHeight = viewBox.height() > 0.0 ? new Some((Object)BoxesRunTime.boxToDouble((double)viewBox.height())) : None$.MODULE$);
            if (definedWidth.isEmpty() || definedHeight.isEmpty() || force) {
                DoubleRef minX = DoubleRef.create((double)0.0);
                DoubleRef minY = DoubleRef.create((double)0.0);
                DoubleRef maxX = DoubleRef.create((double)0.0);
                DoubleRef maxY = DoubleRef.create((double)0.0);
                dom$.MODULE$.domListToIterator((DOMList)svg.children()).foreach((Function1 & Serializable & scala.Serializable)child -> {
                    SVGImage$.measureInternal$1(child, 0.0, 0.0, minX, minY, maxX, maxY);
                    return BoxedUnit.UNIT;
                });
                immutableBoundingBox = BoundingBox$.MODULE$.apply(minX.elem, minY.elem, maxX.elem, maxY.elem);
            } else {
                immutableBoundingBox = bb = BoundingBox$.MODULE$.apply(0.0, 0.0, BoxesRunTime.unboxToDouble((Object)definedWidth.get()), BoxesRunTime.unboxToDouble((Object)definedHeight.get()));
            }
            if (!applyDimension) break block2;
            svg.setAttribute("width", ((Object)BoxesRunTime.boxToDouble((double)bb.width())).toString());
            svg.setAttribute("height", ((Object)BoxesRunTime.boxToDouble((double)bb.height())).toString());
        }
        return bb;
    }

    public boolean measure$default$2() {
        return true;
    }

    public boolean measure$default$3() {
        return false;
    }

    private static final void measureInternal$1(Element e, double offsetX, double offsetY, DoubleRef minX$1, DoubleRef minY$1, DoubleRef maxX$1, DoubleRef maxY$1) {
        Element element = e;
        if (element instanceof SVGGElement) {
            SVGGElement sVGGElement = (SVGGElement)element;
            DoubleRef ox = DoubleRef.create((double)offsetX);
            DoubleRef oy = DoubleRef.create((double)offsetY);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sVGGElement.transform().baseVal().numberOfItems()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                block0: {
                    SVGTransform transform = sVGGElement.transform().baseVal().getItem(index);
                    if (transform.type() != SVGTransform$.MODULE$.SVG_TRANSFORM_TRANSLATE()) break block0;
                    ox$1.elem += transform.matrix().e();
                    oy$1.elem += transform.matrix().f();
                }
            });
            dom$.MODULE$.domListToIterator((DOMList)sVGGElement.children()).foreach((Function1 & Serializable & scala.Serializable)child -> {
                SVGImage$.measureInternal$1(child, ox.elem, oy.elem, minX$1, minY$1, maxX$1, maxY$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGCircleElement) {
            SVGCircleElement sVGCircleElement = (SVGCircleElement)element;
            minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + (sVGCircleElement.cx().baseVal().value() - sVGCircleElement.r().baseVal().value()));
            minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + (sVGCircleElement.cy().baseVal().value() - sVGCircleElement.r().baseVal().value()));
            maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + (sVGCircleElement.cx().baseVal().value() + sVGCircleElement.r().baseVal().value()));
            maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + (sVGCircleElement.cy().baseVal().value() + sVGCircleElement.r().baseVal().value()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGEllipseElement) {
            SVGEllipseElement sVGEllipseElement = (SVGEllipseElement)element;
            minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + (sVGEllipseElement.cx().baseVal().value() - sVGEllipseElement.rx().baseVal().value()));
            minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + (sVGEllipseElement.cy().baseVal().value() - sVGEllipseElement.ry().baseVal().value()));
            maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + (sVGEllipseElement.cx().baseVal().value() + sVGEllipseElement.rx().baseVal().value()));
            maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + (sVGEllipseElement.cy().baseVal().value() + sVGEllipseElement.ry().baseVal().value()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGRectElement) {
            SVGRectElement sVGRectElement = (SVGRectElement)element;
            minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + sVGRectElement.x().baseVal().value());
            minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + sVGRectElement.y().baseVal().value());
            maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + sVGRectElement.x().baseVal().value() + sVGRectElement.width().baseVal().value());
            maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + sVGRectElement.y().baseVal().value() + sVGRectElement.height().baseVal().value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGImageElement) {
            SVGImageElement sVGImageElement = (SVGImageElement)element;
            minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + sVGImageElement.x().baseVal().value());
            minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + sVGImageElement.y().baseVal().value());
            maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + sVGImageElement.x().baseVal().value() + sVGImageElement.width().baseVal().value());
            maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + sVGImageElement.y().baseVal().value() + sVGImageElement.height().baseVal().value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGLinearGradientElement) {
            SVGLinearGradientElement sVGLinearGradientElement = (SVGLinearGradientElement)element;
            minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + sVGLinearGradientElement.x1().baseVal().value());
            minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + sVGLinearGradientElement.y1().baseVal().value());
            maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + sVGLinearGradientElement.x2().baseVal().value());
            maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + sVGLinearGradientElement.y2().baseVal().value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGPolygonElement) {
            SVGPolygonElement sVGPolygonElement = (SVGPolygonElement)element;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sVGPolygonElement.points().numberOfItems()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                SVGPoint point = sVGPolygonElement.points().getItem(index);
                minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + point.x());
                minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + point.y());
                maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + point.x());
                maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + point.y());
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGPathElement) {
            SVGPathElement sVGPathElement = (SVGPathElement)element;
            Path path = Path$.MODULE$.apply(sVGPathElement.getAttribute("d"));
            minX$1.elem = scala.math.package$.MODULE$.min(minX$1.elem, offsetX + path.boundingBox().x1());
            minY$1.elem = scala.math.package$.MODULE$.min(minY$1.elem, offsetY + path.boundingBox().y1());
            maxX$1.elem = scala.math.package$.MODULE$.max(maxX$1.elem, offsetX + path.boundingBox().x2());
            maxY$1.elem = scala.math.package$.MODULE$.max(maxY$1.elem, offsetY + path.boundingBox().y2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (element instanceof SVGStyleElement) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Warn$.MODULE$, Level.Warn$.MODULE$.value(), (scala.Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SVG node: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})), LogRecord.Stringify$.MODULE$.Default(), "io.youi.image.SVGImage.bb", (Option)new Some((Object)"measureInternal"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)184)), LogRecord$.MODULE$.apply$default$8(), LogRecord$.MODULE$.apply$default$9()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SVGImage$() {
        MODULE$ = this;
    }
}

