/*
 * Decompiled with CFR 0.152.
 */
package io.youi.util;

import io.youi.SingleThreadedFuture;
import io.youi.SingleThreadedFuture$;
import io.youi.dom$;
import io.youi.image.Image;
import io.youi.image.Image$;
import io.youi.image.resize.ImageResizer;
import io.youi.package$;
import io.youi.util.CanvasPool$;
import io.youi.util.Scaled;
import io.youi.util.SizeUtility$;
import io.youi.video.Video$;
import java.io.Serializable;
import org.scalajs.dom.raw.Blob;
import org.scalajs.dom.raw.CanvasRenderingContext2D;
import org.scalajs.dom.raw.Event;
import org.scalajs.dom.raw.File;
import org.scalajs.dom.raw.FileReader;
import org.scalajs.dom.raw.HTMLCanvasElement;
import org.scalajs.dom.raw.HTMLElement;
import org.scalajs.dom.raw.HTMLImageElement;
import org.scalajs.dom.raw.URL$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.;
import scala.scalajs.js.Any;
import scala.scalajs.js.Function1;
import scala.util.Try;
import scribe.Level;
import scribe.LogRecord;
import scribe.LogRecord$;

public final class ImageUtility$ {
    public static ImageUtility$ MODULE$;
    private final HTMLImageElement tempImage;
    private final SingleThreadedFuture loadImageFuture;

    static {
        new ImageUtility$();
    }

    public Future<HTMLCanvasElement> drawToCanvas(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer, double offsetX, double offsetY, double width, double height) {
        return CanvasPool$.MODULE$.withCanvasFuture(width, height, CanvasPool$.MODULE$.withCanvasFuture$default$3(), (scala.Function1 & Serializable & scala.Serializable)canvas -> resizer.resize(source, (HTMLCanvasElement)canvas).map((scala.Function1 & Serializable & scala.Serializable)x$1 -> {
            CanvasRenderingContext2D qual$1 = package$.MODULE$.ExtendedCanvas(destination).context();
            HTMLCanvasElement x$16 = canvas;
            double x$17 = offsetX;
            double x$18 = offsetY;
            double x$19 = width;
            double x$20 = height;
            double x$21 = qual$1.drawImage$default$6();
            double x$22 = qual$1.drawImage$default$7();
            double x$23 = qual$1.drawImage$default$8();
            double x$24 = qual$1.drawImage$default$9();
            qual$1.drawImage((HTMLElement)x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            return destination;
        }, ExecutionContext.Implicits$.MODULE$.global()));
    }

    public double drawToCanvas$default$4(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return 0.0;
    }

    public double drawToCanvas$default$5(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return 0.0;
    }

    public double drawToCanvas$default$6(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return ((HTMLImageElement)source).width();
    }

    public double drawToCanvas$default$7(.bar<HTMLImageElement, HTMLCanvasElement> source, HTMLCanvasElement destination, ImageResizer resizer) {
        return ((HTMLImageElement)source).height();
    }

    public Future<HTMLImageElement> resizeToImage(.bar<HTMLImageElement, HTMLCanvasElement> source, double width, double height, HTMLImageElement destination, ImageResizer resizer) {
        return this.resizeToDataURL(source, width, height, resizer).map((scala.Function1 & Serializable & scala.Serializable)dataURL -> {
            destination.src_$eq(dataURL);
            return destination;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<String> resizeToDataURL(.bar<HTMLImageElement, HTMLCanvasElement> source, double width, double height, ImageResizer resizer) {
        HTMLCanvasElement destinationCanvas = CanvasPool$.MODULE$.apply(width, height, CanvasPool$.MODULE$.apply$default$3());
        Future loader = ((HTMLImageElement)source).width() == 0 || ((HTMLImageElement)source).height() == 0 ? this.loadImage((HTMLImageElement)source) : Future$.MODULE$.successful((Object)((HTMLImageElement)source));
        Future future = loader.flatMap((scala.Function1 & Serializable & scala.Serializable)x$2 -> {
            .bar x$25 = source;
            HTMLCanvasElement x$26 = destinationCanvas;
            ImageResizer x$27 = resizer;
            double x$28 = destinationCanvas.width();
            double x$29 = destinationCanvas.height();
            double x$30 = MODULE$.drawToCanvas$default$4((.bar<HTMLImageElement, HTMLCanvasElement>)x$25, x$26, x$27);
            double x$31 = MODULE$.drawToCanvas$default$5((.bar<HTMLImageElement, HTMLCanvasElement>)x$25, x$26, x$27);
            return MODULE$.drawToCanvas((.bar<HTMLImageElement, HTMLCanvasElement>)x$25, x$26, x$27, x$30, x$31, x$28, x$29).map((scala.Function1 & Serializable & scala.Serializable)x$3 -> destinationCanvas.toDataURL("image/png", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Any[0])), ExecutionContext.Implicits$.MODULE$.global());
        }, ExecutionContext.Implicits$.MODULE$.global());
        future.onComplete((scala.Function1 & Serializable & scala.Serializable)x$4 -> {
            CanvasPool$.MODULE$.restore(destinationCanvas);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return future;
    }

    private HTMLImageElement tempImage() {
        return this.tempImage;
    }

    private SingleThreadedFuture loadImageFuture() {
        return this.loadImageFuture;
    }

    public <R> Future<R> loadImage(File file, scala.Function1<HTMLImageElement, Future<R>> process) {
        return this.loadImageFuture().apply((Function0 & Serializable & scala.Serializable)() -> {
            Promise promise = Promise$.MODULE$.apply();
            Function1<Event, Promise<BoxedUnit>> listener = new Function1<Event, Promise<BoxedUnit>>(promise){
                private final Promise promise$1;

                public final Promise<BoxedUnit> apply(Event arg1) {
                    return ImageUtility$.io$youi$util$ImageUtility$$$anonfun$loadImage$2(arg1, this.promise$1);
                }
                {
                    this.promise$1 = promise$1;
                    super((Seq)Nil$.MODULE$);
                }
            };
            MODULE$.tempImage().addEventListener("load", (Function1)listener, MODULE$.tempImage().addEventListener$default$3());
            MODULE$.loadDataURL(file, MODULE$.loadDataURL$default$2()).foreach((scala.Function1 & Serializable & scala.Serializable)x$6 -> {
                ImageUtility$.$anonfun$loadImage$3(x$6);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
            return promise.future().flatMap(arg_0 -> ImageUtility$.$anonfun$loadImage$4(process, (Function1)listener, arg_0), ExecutionContext.Implicits$.MODULE$.global());
        });
    }

    public Future<HTMLImageElement> loadImage(HTMLImageElement img) {
        Future future;
        if (img.width() > 0 && img.height() > 0) {
            future = Future$.MODULE$.successful((Object)img);
        } else {
            Promise promise = Promise$.MODULE$.apply();
            Function1<Event, Promise<HTMLImageElement>> listener = new Function1<Event, Promise<HTMLImageElement>>(img, promise){
                private final HTMLImageElement img$2;
                private final Promise promise$2;

                public final Promise<HTMLImageElement> apply(Event arg1) {
                    return ImageUtility$.io$youi$util$ImageUtility$$$anonfun$loadImage$6(arg1, this.img$2, this.promise$2);
                }
                {
                    this.img$2 = img$2;
                    this.promise$2 = promise$2;
                    super((Seq)Nil$.MODULE$);
                }
            };
            img.addEventListener("load", (Function1)listener, img.addEventListener$default$3());
            Future future2 = promise.future();
            future2.onComplete(arg_0 -> ImageUtility$.$anonfun$loadImage$7$adapted(img, (Function1)listener, arg_0), ExecutionContext.Implicits$.MODULE$.global());
            future = future2;
        }
        return future;
    }

    public Future<String> toDataURL(HTMLImageElement img) {
        return this.loadImage(img).map((scala.Function1 & Serializable & scala.Serializable)x$11 -> (String)CanvasPool$.MODULE$.withCanvas(img.width(), img.height(), CanvasPool$.MODULE$.withCanvas$default$3(), (scala.Function1 & Serializable & scala.Serializable)canvas -> {
            CanvasRenderingContext2D ctx = (CanvasRenderingContext2D)canvas.getContext("2d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Any[0]));
            ctx.drawImage((HTMLElement)img, 0.0, 0.0, ctx.drawImage$default$4(), ctx.drawImage$default$5(), ctx.drawImage$default$6(), ctx.drawImage$default$7(), ctx.drawImage$default$8(), ctx.drawImage$default$9());
            return canvas.toDataURL("image/png", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Any[0]));
        }), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<String> loadDataURL(File file, boolean useFileReader) {
        Future future;
        if (useFileReader) {
            FileReader reader = new FileReader();
            Promise promise = Promise$.MODULE$.apply();
            reader.addEventListener("load", (Function1)new Function1<Event, Promise<String>>(reader, promise){
                private final FileReader reader$1;
                private final Promise promise$3;

                public final Promise<String> apply(Event arg1) {
                    return ImageUtility$.io$youi$util$ImageUtility$$$anonfun$loadDataURL$1(arg1, this.reader$1, this.promise$3);
                }
                {
                    this.reader$1 = reader$1;
                    this.promise$3 = promise$3;
                    super((Seq)Nil$.MODULE$);
                }
            }, reader.addEventListener$default$3());
            reader.readAsDataURL((Blob)file);
            Future future2 = promise.future();
            future2.failed().foreach((scala.Function1 & Serializable & scala.Serializable)x$12 -> {
                scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & Serializable & scala.Serializable)() -> x$12, LogRecord.Stringify$.MODULE$.Default(), "io.youi.util.ImageUtility", (Option)new Some((Object)"loadDataURL"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)114)), LogRecord$.MODULE$.apply$default$8(), LogRecord$.MODULE$.apply$default$9()));
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
            future = future2;
        } else {
            future = Future$.MODULE$.successful((Object)URL$.MODULE$.createObjectURL((Blob)file));
        }
        return future;
    }

    public boolean loadDataURL$default$2() {
        return false;
    }

    public Future<String> loadText(File file) {
        FileReader reader = new FileReader();
        Promise promise = Promise$.MODULE$.apply();
        reader.addEventListener("load", (Function1)new Function1<Event, Promise<String>>(reader, promise){
            private final FileReader reader$2;
            private final Promise promise$4;

            public final Promise<String> apply(Event arg1) {
                return ImageUtility$.io$youi$util$ImageUtility$$$anonfun$loadText$1(arg1, this.reader$2, this.promise$4);
            }
            {
                this.reader$2 = reader$2;
                this.promise$4 = promise$4;
                super((Seq)Nil$.MODULE$);
            }
        }, reader.addEventListener$default$3());
        reader.readAsText((Blob)file, reader.readAsText$default$2());
        Future future = promise.future();
        future.failed().foreach((scala.Function1 & Serializable & scala.Serializable)x$14 -> {
            scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & Serializable & scala.Serializable)() -> x$14, LogRecord.Stringify$.MODULE$.Default(), "io.youi.util.ImageUtility", (Option)new Some((Object)"loadText"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)128)), LogRecord$.MODULE$.apply$default$8(), LogRecord$.MODULE$.apply$default$9()));
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return future;
    }

    public Future<Option<Image>> preview(File file) {
        return Video$.MODULE$.isVideo(file) ? Video$.MODULE$.apply(file, false, false, true).flatMap((scala.Function1 & Serializable & scala.Serializable)video -> video.seek(video.duration() / 2.0).map((scala.Function1 & Serializable & scala.Serializable)x$15 -> {
            Image image = video.createImage();
            video.dispose();
            return new Some((Object)image);
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global()) : (Image$.MODULE$.isImage(file) ? Image$.MODULE$.apply(file).map((scala.Function1 & Serializable & scala.Serializable)value -> new Some(value), ExecutionContext.Implicits$.MODULE$.global()) : Future$.MODULE$.successful((Object)None$.MODULE$));
    }

    public Future<Option<Image>> preview(File file, double width, double height, boolean scaleUp) {
        return this.preview(file).flatMap((scala.Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Image image = (Image)some.value();
                Scaled scaled = SizeUtility$.MODULE$.scale(image.width(), image.height(), width, height, scaleUp);
                future = image.resize(scaled.width(), scaled.height()).map((scala.Function1 & Serializable & scala.Serializable)resized -> {
                    image.dispose();
                    return new Some(resized);
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Option<String>> generatePreview(File file, double width, double height, boolean scaleUp) {
        return this.preview(file, width, height, scaleUp).flatMap((scala.Function1 & Serializable & scala.Serializable)x0$2 -> {
            Future future;
            Option option = x0$2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Image image = (Image)some.value();
                future = image.toDataURL().map((scala.Function1 & Serializable & scala.Serializable)value -> new Some(value), ExecutionContext.Implicits$.MODULE$.global());
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public boolean generatePreview$default$4() {
        return false;
    }

    public static final /* synthetic */ Promise io$youi$util$ImageUtility$$$anonfun$loadImage$2(Event x$5, Promise promise$1) {
        return promise$1.success((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$loadImage$3(String x$6) {
        MODULE$.tempImage().src_$eq(x$6);
    }

    public static final /* synthetic */ void $anonfun$loadImage$5(Try x$8) {
        MODULE$.tempImage().src_$eq("");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Future $anonfun$loadImage$4(scala.Function1 process$1, Function1 listener$1, BoxedUnit x$7) {
        void var3_3;
        MODULE$.tempImage().removeEventListener("load", listener$1, MODULE$.tempImage().removeEventListener$default$3());
        Future f = (Future)process$1.apply((Object)MODULE$.tempImage());
        f.onComplete((scala.Function1 & Serializable & scala.Serializable)x$8 -> {
            ImageUtility$.$anonfun$loadImage$5(x$8);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return var3_3;
    }

    public static final /* synthetic */ Promise io$youi$util$ImageUtility$$$anonfun$loadImage$6(Event x$9, HTMLImageElement img$2, Promise promise$2) {
        return promise$2.success((Object)img$2);
    }

    public static final /* synthetic */ Promise io$youi$util$ImageUtility$$$anonfun$loadDataURL$1(Event evt, FileReader reader$1, Promise promise$3) {
        return promise$3.success((Object)((String)reader$1.result()));
    }

    public static final /* synthetic */ Promise io$youi$util$ImageUtility$$$anonfun$loadText$1(Event x$13, FileReader reader$2, Promise promise$4) {
        return promise$4.success((Object)((String)reader$2.result()));
    }

    private ImageUtility$() {
        MODULE$ = this;
        this.tempImage = (HTMLImageElement)dom$.MODULE$.create("img");
        this.loadImageFuture = new SingleThreadedFuture(SingleThreadedFuture$.MODULE$.$lessinit$greater$default$1());
    }

    public static final /* synthetic */ Object $anonfun$loadImage$7$adapted(HTMLImageElement img$2, Function1 listener$2, Try x$10) {
        img$2.removeEventListener("load", listener$2, img$2.removeEventListener$default$3());
        return BoxedUnit.UNIT;
    }
}

