/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.kubernetes.operator.base.impl;

import io.yupiik.fusion.kubernetes.client.KubernetesClient;
import io.yupiik.fusion.kubernetes.client.KubernetesClientConfiguration;
import io.yupiik.kubernetes.operator.base.impl.OperatorConfiguration;
import io.yupiik.kubernetes.operator.base.impl.Threads;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Beans {
    public Threads threads() {
        return new Threads(Executors.newScheduledThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "io.yupiik.fusion.kubernetes.operator-" + this.counter.incrementAndGet());
            }
        }));
    }

    public ScheduledExecutorService simpleThreads(Threads threads2) {
        return threads2.executor();
    }

    public KubernetesClient kubernetesClient(OperatorConfiguration configuration, ScheduledExecutorService executor) {
        return new KubernetesClient(new KubernetesClientConfiguration().setClientCustomizer(b -> b.connectTimeout(Duration.ofMinutes(1L)).executor(executor)).setMaster(configuration.kubernetes().master()).setToken(configuration.kubernetes().token()).setCertificates(configuration.kubernetes().certificates()).setSkipTls(configuration.kubernetes().skipTls()));
    }
}

