/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.kubernetes.operator.base.impl;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.yupiik.fusion.framework.api.lifecycle.Start;
import io.yupiik.fusion.framework.api.main.Awaiter;
import io.yupiik.fusion.json.JsonMapper;
import io.yupiik.fusion.kubernetes.client.KubernetesClient;
import io.yupiik.kubernetes.operator.base.impl.OperatorConfiguration;
import io.yupiik.kubernetes.operator.base.impl.OperatorRuntime;
import io.yupiik.kubernetes.operator.base.spi.Operator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;

public class OperatorsLifecycle
implements Awaiter {
    private final List<Operator<?>> operatorSpecs;
    private final OperatorConfiguration configuration;
    private final KubernetesClient kubernetes;
    private final ScheduledExecutorService threads;
    private final JsonMapper jsonMapper;
    private final List<OperatorRuntime<?>> operators = new ArrayList();
    private HttpServer probes;

    public OperatorsLifecycle(List<Operator<?>> operatorSpecs, OperatorConfiguration configuration, KubernetesClient kubernetes, ScheduledExecutorService threads2, JsonMapper jsonMapper) {
        this.operatorSpecs = operatorSpecs;
        this.configuration = configuration;
        this.kubernetes = kubernetes;
        this.threads = threads2;
        this.jsonMapper = jsonMapper;
    }

    public void onStart(Start ignored) {
        this.startProbeIfNeeded();
        this.operators.addAll(this.operatorSpecs.stream().map(spec -> new OperatorRuntime(this.configuration, this.kubernetes, this.threads, this.jsonMapper, spec)).toList());
        try {
            CompletableFuture.allOf((CompletableFuture[])this.operators.stream().map(OperatorRuntime::doStart).toArray(CompletableFuture[]::new)).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private void startProbeIfNeeded() {
        if (this.configuration.probePort() < 0) {
            return;
        }
        try {
            this.probes = HttpServer.create(new InetSocketAddress(this.configuration.probePort()), 128);
            this.probes.setExecutor(this.threads);
            this.probes.createContext("/", exchange -> {
                try (HttpExchange httpExchange = exchange;){
                    if (!"GET".equals(exchange.getRequestMethod())) {
                        exchange.sendResponseHeaders(404, 0L);
                        return;
                    }
                    switch (exchange.getRequestURI().getPath()) {
                        case "/health": {
                            exchange.sendResponseHeaders(200, 0L);
                            return;
                        }
                        case "/metrics": {
                            exchange.sendResponseHeaders(200, 0L);
                            return;
                        }
                        default: {
                            exchange.sendResponseHeaders(404, 0L);
                            return;
                        }
                    }
                }
            });
            this.probes.start();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void onStop() {
        IllegalStateException errors = new IllegalStateException("Some error occurred");
        this.operators.forEach(o -> {
            try {
                o.doStop();
            }
            catch (RuntimeException re) {
                errors.addSuppressed(re);
            }
        });
        if (this.probes != null) {
            this.probes.stop(0);
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    public void await() {
        this.operators.forEach(OperatorRuntime::await);
    }
}

