/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.kubernetes.operator.base.impl;

import io.yupiik.fusion.json.JsonMapper;
import io.yupiik.kubernetes.operator.base.impl.Event;
import io.yupiik.kubernetes.operator.base.impl.ObjectLike;
import io.yupiik.kubernetes.operator.base.impl.OperatorState;
import io.yupiik.kubernetes.operator.base.spi.Operator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class SimpleController<T extends ObjectLike> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ScheduledExecutorService threads;
    private final JsonMapper jsonMapper;
    private final int threadCount;
    private final Operator<T> operator;
    protected final OperatorState<T> state = new OperatorState();
    protected final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    protected volatile boolean stopping = false;

    public SimpleController(ScheduledExecutorService threads2, JsonMapper jsonMapper, int threadCount, Operator<T> operator) {
        this.threads = threads2;
        this.jsonMapper = jsonMapper;
        this.threadCount = threadCount;
        this.operator = operator;
    }

    private void internalOnAdd(T object) {
        this.stateAdd(object);
        this.operator.onAdd(object);
    }

    private void internalOnModified(T object) {
        this.stateDelete(object);
        this.stateAdd(object);
        this.operator.onModify(object);
    }

    private void internalOnDelete(T object) {
        this.stateDelete(object);
        this.operator.onDelete(object);
    }

    private void stateAdd(T object) {
        this.state.items().add(object);
    }

    private void stateDelete(T object) {
        this.state.items().removeIf(o -> Objects.equals(o.metadata().uid(), object.metadata().uid()));
    }

    public void init() {
        for (int i = 0; i < this.threadCount; ++i) {
            this.threads.execute(this::eventLoop);
        }
    }

    public void onEvent(String event) {
        if (!this.queue.offer(event)) {
            this.logger.severe(() -> "Can't handle event '" + event + "', ignoring");
        }
    }

    private void handleEvent(String line) {
        Event data = (Event)this.jsonMapper.fromString(Event.class, line);
        if (data.type() == null || data.object() == null) {
            this.logger.warning(() -> "Ignoring event: " + String.valueOf(data));
            return;
        }
        switch (data.type()) {
            case "ERROR": {
                this.logger.severe(line);
                this.operator.onError(line);
                break;
            }
            case "BOOKMARK": {
                String resourceVersion;
                Map metadata;
                Map bookmark = (Map)this.jsonMapper.fromString(Object.class, line);
                if (bookmark == null || (metadata = (Map)bookmark.get("metadata")) == null || (resourceVersion = (String)metadata.get("resourceVersion")) == null || resourceVersion.isBlank()) break;
                this.operator.onBookmark(resourceVersion);
                this.onBookmark(resourceVersion);
                break;
            }
            case "ADDED": {
                this.internalOnAdd(this.asObject(data.object()));
                break;
            }
            case "MODIFIED": {
                this.internalOnModified(this.asObject(data.object()));
                break;
            }
            case "DELETED": {
                this.internalOnDelete(this.asObject(data.object()));
                break;
            }
            default: {
                this.logger.warning(() -> "Ignoring event: " + String.valueOf(data));
            }
        }
    }

    protected void onBookmark(String resourceVersion) {
    }

    private T asObject(Map<String, Object> object) {
        return (T)((ObjectLike)this.jsonMapper.fromString(this.operator.resourceType(), this.jsonMapper.toString(object)));
    }

    private void eventLoop() {
        while (!this.stopping) {
            try {
                String poll = this.queue.poll(10L, TimeUnit.SECONDS);
                if (poll == null) continue;
                this.handleEvent(poll);
            }
            catch (InterruptedException e) {
                this.logger.info("Exiting from controller on interruption");
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.logger.info("Exiting from controller");
    }

    public void stop() {
        this.stopping = true;
    }
}

