/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.kubernetes.operator.base.spi;

import io.yupiik.kubernetes.operator.base.impl.ObjectLike;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface Operator<T extends ObjectLike> {
    default public void onAdd(T resource) {
    }

    default public void onModify(T resource) {
        this.onDelete(resource);
        this.onAdd(resource);
    }

    default public void onDelete(T resource) {
    }

    default public void onError(String error) {
    }

    default public void onBookmark(String resourceVersion) {
    }

    default public CompletionStage<?> onStart() {
        return CompletableFuture.completedFuture(true);
    }

    default public void onStop() {
    }

    public Class<T> resourceType();

    public String pluralName();

    public String apiVersion();

    default public boolean namespaced() {
        return true;
    }

    default public List<String> namespaces() {
        return List.of();
    }

    public record DefaultOperatorConfiguration(boolean namespaced, List<String> namespaces, String pluralResource, String apiVersion) {
    }

    public static class Base<T extends ObjectLike>
    implements Operator<T> {
        private final Class<T> resourceType;
        private final DefaultOperatorConfiguration configuration;

        public Base(Class<T> resourceType, DefaultOperatorConfiguration configuration) {
            this.resourceType = resourceType;
            this.configuration = configuration;
        }

        @Override
        public Class<T> resourceType() {
            return this.resourceType;
        }

        @Override
        public String pluralName() {
            return this.configuration.pluralResource();
        }

        @Override
        public String apiVersion() {
            return this.configuration.apiVersion();
        }

        @Override
        public boolean namespaced() {
            return this.configuration.namespaced();
        }

        @Override
        public List<String> namespaces() {
            return this.configuration.namespaces();
        }
    }
}

