/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.doc;

import io.yupiik.uship.backbone.reflect.Reflections;
import io.yupiik.uship.jsonrpc.core.api.JsonRpcError;
import io.yupiik.uship.jsonrpc.core.api.JsonRpcMethod;
import io.yupiik.uship.jsonrpc.core.api.JsonRpcParam;
import io.yupiik.uship.jsonrpc.core.impl.Registration;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseJsonRpcDocumentationGenerator
implements Runnable {
    private final Collection<Class<?>> endpoints;
    private final PrintStream output;

    public BaseJsonRpcDocumentationGenerator(Collection<Class<?>> endpoints, PrintStream output) {
        this.endpoints = endpoints;
        this.output = output;
    }

    @Override
    public void run() {
        this.doRun(this.forRegistrations(), this.output);
    }

    protected String toString(Registration registration) {
        return registration.toString();
    }

    protected String asString(Type type) {
        return type.getTypeName().replace("java.lang.", "").replace("java.util.", "");
    }

    protected void doRun(Stream<Registration> forRegistrations, PrintStream output) {
        output.println(forRegistrations.map(this::toString).sorted().collect(Collectors.joining("\n")));
    }

    protected Stream<Registration> forRegistrations() {
        return this.endpoints.stream().flatMap(this::toRegistration);
    }

    private Stream<Registration> toRegistration(Class<?> aClass) {
        List list = Stream.of(aClass.getMethods()).filter(it -> it.isAnnotationPresent(JsonRpcMethod.class)).map(method -> {
            AtomicInteger idx = new AtomicInteger(-1);
            Optional<JsonRpcMethod> config = Optional.of(method.getAnnotation(JsonRpcMethod.class));
            return new Registration(aClass, method, config.map(JsonRpcMethod::name).orElse(method.getDeclaringClass().getName() + "." + method.getName()), Reflections.extractRealType((Class)aClass, (Type)method.getGenericReturnType()), a -> null, (Collection)Stream.of(method.getParameters()).map(p -> {
                Optional<JsonRpcParam> conf = Optional.ofNullable(p.getAnnotation(JsonRpcParam.class));
                idx.incrementAndGet();
                return new Registration.Parameter(Reflections.resolveType((Type)Reflections.extractRealType((Class)aClass, (Type)p.getParameterizedType()), (Class)aClass), conf.map(JsonRpcParam::value).filter(it -> !it.isEmpty()).orElseGet(() -> p.getName()), idx.get(), conf.map(JsonRpcParam::required).orElse(false).booleanValue(), conf.map(JsonRpcParam::documentation).orElse(""));
            }).collect(Collectors.toList()), (Collection)Optional.ofNullable((JsonRpcError[])method.getAnnotationsByType(JsonRpcError.class)).map(ex -> Stream.of(ex).map(e -> new Registration.ExceptionMapping(Arrays.asList(e.handled()), e.code(), e.documentation())).collect(Collectors.toList())).orElseGet(Collections::emptyList), config.map(JsonRpcMethod::documentation).orElse(""));
        }).collect(Collectors.toList());
        List dropped = list.stream().filter(m -> list.stream().anyMatch(it -> it.jsonRpcMethod().equals(m.jsonRpcMethod()) && m != it && m.method().getDeclaringClass().isAssignableFrom(it.method().getDeclaringClass()))).collect(Collectors.toList());
        list.removeAll(dropped);
        return list.stream();
    }
}

