/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.doc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CliSibling {
    private CliSibling() {
    }

    public static Reader toReader(String arg) throws IOException {
        if ("stdin".equals(Optional.ofNullable(arg).orElse("stdin"))) {
            return new BufferedReader(new InputStreamReader(System.in)){

                @Override
                public void close() {
                }
            };
        }
        Path path = Paths.get(arg, new String[0]);
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        return Files.newBufferedReader(path);
    }

    public static PrintStream toOutputStream(String arg) throws IOException {
        switch (Optional.ofNullable(arg).orElse("stdout")) {
            case "stdout": {
                return new PrintStream(System.out){

                    @Override
                    public void close() {
                        this.flush();
                    }
                };
            }
            case "stderr": {
                return new PrintStream(System.err){

                    @Override
                    public void close() {
                        this.flush();
                    }
                };
            }
        }
        Path path = Paths.get(arg, new String[0]);
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        return new PrintStream(Files.newOutputStream(path, new OpenOption[0]));
    }

    public static List<Class<?>> mapClasses(String arg) {
        return Stream.of(arg.split(",")).map(String::trim).filter(it -> !it.isBlank()).map(clazz -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
    }
}

