/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractClientConnection;
import io.atomix.cluster.messaging.impl.HandlerRegistry;
import io.atomix.cluster.messaging.impl.LocalServerConnection;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

final class LocalClientConnection
extends AbstractClientConnection {
    private final LocalServerConnection serverConnection;

    LocalClientConnection(ScheduledExecutorService executorService, HandlerRegistry handlers) {
        super(executorService);
        this.serverConnection = new LocalServerConnection(handlers, this);
    }

    @Override
    public CompletableFuture<Void> sendAsync(ProtocolRequest message) {
        this.serverConnection.dispatch(message);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(ProtocolRequest message, Duration timeout) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        new AbstractClientConnection.Callback(this, message.id(), message.subject(), timeout, future);
        this.serverConnection.dispatch(message);
        return future;
    }

    @Override
    public void close() {
        super.close();
        this.serverConnection.close();
    }
}

