/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionManagementService;
import io.atomix.utils.concurrent.Futures;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionService
implements ManagedPartitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionService.class);
    private final ClusterMembershipService clusterMembershipService;
    private final ClusterCommunicationService communicationService;
    private volatile PartitionManagementService partitionManagementService;
    private final Map<String, ManagedPartitionGroup> groups = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();

    public DefaultPartitionService(ClusterMembershipService membershipService, ClusterCommunicationService messagingService, Collection<ManagedPartitionGroup> groups) {
        this.clusterMembershipService = membershipService;
        this.communicationService = messagingService;
        groups.forEach(group -> this.groups.put(group.name(), (ManagedPartitionGroup)group));
    }

    @Override
    public PartitionGroup getPartitionGroup(String name) {
        return this.groups.get(name);
    }

    @Override
    public Collection<PartitionGroup> getPartitionGroups() {
        return this.groups.values();
    }

    public CompletableFuture<PartitionService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.partitionManagementService = new DefaultPartitionManagementService(this.clusterMembershipService, this.communicationService);
            return Futures.allOf(this.groups.values().stream().map(grp -> grp.join(this.partitionManagementService)).collect(Collectors.toList())).thenApply(v -> {
                LOGGER.debug("Started {}", this.getClass());
                this.started.set(true);
                return this;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        Stream<CompletableFuture> groupStream = this.groups.values().stream().map(ManagedPartitionGroup::close);
        List<CompletableFuture> futures = groupStream.collect(Collectors.toList());
        return ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).exceptionally(throwable -> {
            LOGGER.error("Failed closing partition group(s)", throwable);
            return null;
        })).thenRun(() -> {
            LOGGER.info("Stopped");
            this.started.set(false);
        });
    }
}

