/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl.zeebe;

import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.metrics.RaftServiceMetrics;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public final class LogCompactor {
    private final RaftContext raft;
    private final Logger logger;
    private final RaftServiceMetrics metrics;
    private volatile long compactableIndex;

    public LogCompactor(RaftContext raft) {
        this.raft = raft;
        this.logger = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(this.getClass()).addValue((Object)raft.getName()).build());
        this.metrics = new RaftServiceMetrics(raft.getName());
    }

    public ThreadContext executor() {
        return this.raft.getThreadContext();
    }

    public CompletableFuture<Void> compact() {
        this.raft.checkThread();
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            long startTime = System.currentTimeMillis();
            this.raft.getLog().compact(this.compactableIndex);
            this.metrics.compactionTime(System.currentTimeMillis() - startTime);
            result.complete(null);
        }
        catch (Exception e) {
            this.logger.error("Failed to compact up to index {}", (Object)this.compactableIndex, (Object)e);
            result.completeExceptionally(e);
        }
        return result;
    }

    public void close() {
        this.raft.checkThread();
        this.logger.debug("Closing the log compactor {}", (Object)this.raft.getName());
    }

    public void setCompactableIndex(long index) {
        this.compactableIndex = index;
    }
}

