/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class RaftRoleMetrics
extends RaftMetrics {
    private static final Gauge ROLE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("role")).help("Shows current role")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private static final Counter HEARTBEAT_MISS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("heartbeat_miss_count")).help("Count of missing heartbeats")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private static final Histogram HEARTBEAT_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("heartbeat_time_in_s")).help("Time between heartbeats")).labelNames(new String[]{"partitionGroupName", "partition"})).register();

    public RaftRoleMetrics(String partitionName) {
        super(partitionName);
    }

    public void becomingFollower() {
        ((Gauge.Child)ROLE.labels(new String[]{this.partitionGroupName, this.partition})).set(1.0);
    }

    public void becomingCandidate() {
        ((Gauge.Child)ROLE.labels(new String[]{this.partitionGroupName, this.partition})).set(2.0);
    }

    public void becomingLeader() {
        ((Gauge.Child)ROLE.labels(new String[]{this.partitionGroupName, this.partition})).set(3.0);
    }

    public void countHeartbeatMiss() {
        ((Counter.Child)HEARTBEAT_MISS.labels(new String[]{this.partitionGroupName, this.partition})).inc();
    }

    public void observeHeartbeatInterval(long milliseconds) {
        ((Histogram.Child)HEARTBEAT_TIME.labels(new String[]{this.partitionGroupName, this.partition})).observe((double)((float)milliseconds / 1000.0f));
    }

    public static double getHeartbeatMissCount(String partition) {
        return ((Counter.Child)HEARTBEAT_MISS.labels(new String[]{partition, partition})).get();
    }
}

