/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.RaftFailureListener;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartitionGroupConfig;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartition
implements Partition {
    private static final Logger LOG = LoggerFactory.getLogger(RaftPartition.class);
    private static final String PARTITION_NAME_FORMAT = "%s-partition-%d";
    private final PartitionId partitionId;
    private final RaftPartitionGroupConfig config;
    private final File dataDirectory;
    private final Set<RaftRoleChangeListener> deferredRoleChangeListeners = new CopyOnWriteArraySet<RaftRoleChangeListener>();
    private final Set<RaftFailureListener> raftFailureListeners = new CopyOnWriteArraySet<RaftFailureListener>();
    private PartitionMetadata partitionMetadata;
    private RaftPartitionServer server;

    public RaftPartition(PartitionId partitionId, RaftPartitionGroupConfig config, File dataDirectory) {
        this.partitionId = partitionId;
        this.config = config;
        this.dataDirectory = dataDirectory;
    }

    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        if (this.server == null) {
            this.deferredRoleChangeListeners.add(listener);
        } else {
            this.server.addRoleChangeListener(listener);
        }
    }

    @Deprecated
    public void addRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.addRoleChangeListener((RaftServer.Role newRole, long newTerm) -> listener.accept(newRole));
    }

    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.deferredRoleChangeListeners.remove(listener);
        this.server.removeRoleChangeListener(listener);
    }

    public void addFailureListener(RaftFailureListener failureListener) {
        this.raftFailureListeners.add(failureListener);
    }

    public void removeFailureListener(RaftFailureListener failureListener) {
        this.raftFailureListeners.remove(failureListener);
    }

    public File dataDirectory() {
        return this.dataDirectory;
    }

    public CompletableFuture<Void> snapshot() {
        RaftPartitionServer server = this.server;
        if (server != null) {
            return server.snapshot();
        }
        return CompletableFuture.completedFuture(null);
    }

    CompletableFuture<Partition> open(PartitionMetadata metadata, PartitionManagementService managementService) {
        this.partitionMetadata = metadata;
        if (this.partitionMetadata.members().contains(managementService.getMembershipService().getLocalMember().id())) {
            this.initServer(managementService);
            return this.server.start().thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(this);
    }

    private void initServer(PartitionManagementService managementService) {
        this.server = this.createServer(managementService);
        if (!this.deferredRoleChangeListeners.isEmpty()) {
            this.deferredRoleChangeListeners.forEach(this.server::addRoleChangeListener);
            this.deferredRoleChangeListeners.clear();
        }
        this.server.addFailureListener(this::onFailure);
    }

    protected RaftPartitionServer createServer(PartitionManagementService managementService) {
        return new RaftPartitionServer(this, this.config, managementService.getMembershipService().getLocalMember().id(), managementService.getMembershipService(), managementService.getMessagingService());
    }

    public String name() {
        return String.format(PARTITION_NAME_FORMAT, this.partitionId.group(), this.partitionId.id());
    }

    CompletableFuture<Void> close() {
        return this.closeServer().exceptionally(error -> {
            LOG.error("Error on shutdown partition: {}.", (Object)this.partitionId, error);
            return null;
        });
    }

    private CompletableFuture<Void> closeServer() {
        if (this.server != null) {
            return this.server.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> delete() {
        return this.server.stop().thenRun(() -> {
            if (this.server != null) {
                this.server.delete();
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", (Object)this.id()).toString();
    }

    @Override
    public PartitionId id() {
        return this.partitionId;
    }

    @Override
    public long term() {
        return this.server != null ? this.server.getTerm() : 0L;
    }

    @Override
    public Collection<MemberId> members() {
        return this.partitionMetadata != null ? this.partitionMetadata.members() : Collections.emptyList();
    }

    public RaftServer.Role getRole() {
        return this.server != null ? this.server.getRole() : null;
    }

    public RaftPartitionServer getServer() {
        return this.server;
    }

    public CompletableFuture<Void> stepDown() {
        return this.server.stepDown();
    }

    public CompletableFuture<Void> goInactive() {
        return this.server.goInactive();
    }

    private void onFailure() {
        CompletableFuture.allOf((CompletableFuture[])this.raftFailureListeners.stream().map(RaftFailureListener::onRaftFailed).toArray(CompletableFuture[]::new)).join();
    }
}

