/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroupConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.memory.MemorySize;
import io.atomix.utils.serializer.Namespace;
import io.zeebe.snapshots.raft.ReceivableSnapshotStoreFactory;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionGroup
implements ManagedPartitionGroup {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftPartitionGroup.class);
    private static final Duration SNAPSHOT_TIMEOUT = Duration.ofSeconds(15L);
    private final String name;
    private final RaftPartitionGroupConfig config;
    private final int partitionSize;
    private final Map<PartitionId, RaftPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private final String snapshotSubject;
    private Collection<PartitionMetadata> metadata;
    private ClusterCommunicationService communicationService;

    public RaftPartitionGroup(RaftPartitionGroupConfig config) {
        ContextualLogger log = ContextualLoggerFactory.getLogger(RaftPartitionGroup.class, (LoggerContext)LoggerContext.builder(RaftPartitionGroup.class).addValue((Object)config.getName()).build());
        this.name = config.getName();
        this.config = config;
        this.partitionSize = config.getPartitionSize();
        int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), 4);
        this.snapshotSubject = "raft-partition-group-" + this.name + "-snapshot";
        RaftPartitionGroup.buildPartitions(config).forEach(p -> {
            this.partitions.put(p.id(), (RaftPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    private static Collection<RaftPartition> buildPartitions(RaftPartitionGroupConfig config) {
        File partitionsDir = new File(config.getStorageConfig().getDirectory(config.getName()), "partitions");
        ArrayList<RaftPartition> partitions = new ArrayList<RaftPartition>(config.getPartitions());
        for (int i = 0; i < config.getPartitions(); ++i) {
            partitions.add(new RaftPartition(PartitionId.from(config.getName(), i + 1), config, new File(partitionsDir, String.valueOf(i + 1))));
        }
        return partitions;
    }

    public static Builder builder(String name) {
        return new Builder((RaftPartitionGroupConfig)new RaftPartitionGroupConfig().setName(name));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RaftPartition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    @Override
    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public PartitionGroupConfig config() {
        return this.config;
    }

    public CompletableFuture<Void> snapshot() {
        return Futures.allOf(this.config.getMembers().stream().map(MemberId::from).map(id -> this.communicationService.send(this.snapshotSubject, null, (MemberId)id, SNAPSHOT_TIMEOUT)).collect(Collectors.toList())).thenApply(v -> null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    private CompletableFuture<Void> handleSnapshot() {
        return Futures.allOf(this.partitions.values().stream().map(partition -> partition.snapshot()).collect(Collectors.toList())).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<ManagedPartitionGroup> join(PartitionManagementService managementService) {
        this.metadata = this.buildPartitions();
        this.communicationService = managementService.getMessagingService();
        this.communicationService.subscribe(this.snapshotSubject, m -> this.handleSnapshot());
        List<CompletableFuture> futures = this.metadata.stream().map(metadata -> {
            RaftPartition partition = this.partitions.get(metadata.id());
            return partition.open((PartitionMetadata)metadata, managementService);
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    @Override
    public CompletableFuture<ManagedPartitionGroup> connect(PartitionManagementService managementService) {
        return this.join(managementService);
    }

    @Override
    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(RaftPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> {
            if (this.communicationService != null) {
                this.communicationService.unsubscribe(this.snapshotSubject);
            }
            LOGGER.info("Stopped");
        });
    }

    private Collection<PartitionMetadata> buildPartitions() {
        ArrayList sorted = new ArrayList(this.config.getMembers().stream().map(MemberId::from).collect(Collectors.toSet()));
        Collections.sort(sorted);
        int partitionSize = this.partitionSize;
        if (partitionSize == 0) {
            partitionSize = sorted.size();
        }
        int length = sorted.size();
        int count = Math.min(partitionSize, length);
        HashSet metadata = Sets.newHashSet();
        for (int i = 0; i < this.partitions.size(); ++i) {
            PartitionId partitionId = this.sortedPartitionIds.get(i);
            ArrayList<MemberId> membersForPartition = new ArrayList<MemberId>(count);
            for (int j = 0; j < count; ++j) {
                membersForPartition.add((MemberId)sorted.get((i + j) % length));
            }
            metadata.add(new PartitionMetadata(partitionId, membersForPartition));
        }
        return metadata;
    }

    public static class Builder
    extends PartitionGroup.Builder<RaftPartitionGroupConfig> {
        protected Builder(RaftPartitionGroupConfig config) {
            super(config);
        }

        public Builder withMembers(Collection<String> members) {
            ((RaftPartitionGroupConfig)this.config).setMembers(Sets.newHashSet((Iterable)((Iterable)Preconditions.checkNotNull(members, (Object)"members cannot be null"))));
            return this;
        }

        public Builder withMembers(Member ... members) {
            return this.withMembers(Stream.of(members).map(node -> (String)((Object)node.id().id())).collect(Collectors.toList()));
        }

        public Builder withNumPartitions(int numPartitions) {
            ((RaftPartitionGroupConfig)this.config).setPartitions(numPartitions);
            return this;
        }

        public Builder withPartitionSize(int partitionSize) {
            ((RaftPartitionGroupConfig)this.config).setPartitionSize(partitionSize);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            ((RaftPartitionGroupConfig)this.config).setElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            ((RaftPartitionGroupConfig)this.config).setHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withMaxAppendsPerFollower(int maxAppendsPerFollower) {
            Preconditions.checkArgument((maxAppendsPerFollower > 0 ? 1 : 0) != 0, (Object)"maxAppendsPerFollower must be positive");
            ((RaftPartitionGroupConfig)this.config).setMaxAppendsPerFollower(maxAppendsPerFollower);
            return this;
        }

        public Builder withMaxAppendBatchSize(int maxAppendBatchSize) {
            Preconditions.checkArgument((maxAppendBatchSize > 0 ? 1 : 0) != 0, (Object)"maxAppendBatchSize must be positive");
            ((RaftPartitionGroupConfig)this.config).setMaxAppendBatchSize(maxAppendBatchSize);
            return this;
        }

        public Builder withDataDirectory(File dataDir) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setDirectory(new File("user.dir").toURI().relativize(dataDir.toURI()).getPath());
            return this;
        }

        public Builder withSegmentSize(long segmentSizeBytes) {
            return this.withSegmentSize(new MemorySize(segmentSizeBytes));
        }

        public Builder withSegmentSize(MemorySize segmentSize) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setSegmentSize(segmentSize);
            return this;
        }

        public Builder withMaxEntrySize(int maxEntrySize) {
            return this.withMaxEntrySize(new MemorySize((long)maxEntrySize));
        }

        public Builder withMaxEntrySize(MemorySize maxEntrySize) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setMaxEntrySize(maxEntrySize);
            return this;
        }

        public Builder withFreeDiskSpace(long freeDiskSpace) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setFreeDiskSpace(freeDiskSpace);
            return this;
        }

        public Builder withFlushExplicitly(boolean flushExplicitly) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setFlushExplicitly(flushExplicitly);
            return this;
        }

        public Builder withSnapshotStoreFactory(ReceivableSnapshotStoreFactory persistedSnapshotStoreFactory) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setPersistedSnapshotStoreFactory(persistedSnapshotStoreFactory);
            return this;
        }

        public Builder withEntryValidator(EntryValidator entryValidator) {
            ((RaftPartitionGroupConfig)this.config).setEntryValidator(entryValidator);
            return this;
        }

        public Builder withJournalIndexDensity(int journalIndexDensity) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setJournalIndexDensity(journalIndexDensity);
            return this;
        }

        public RaftPartitionGroup build() {
            return new RaftPartitionGroup((RaftPartitionGroupConfig)this.config);
        }
    }

    public static class Type
    implements PartitionGroup.Type<RaftPartitionGroupConfig> {
        private static final String NAME = "raft";

        public String name() {
            return NAME;
        }

        @Override
        public Namespace namespace() {
            return new Namespace.Builder().nextId(600).register(new Class[]{RaftPartitionGroupConfig.class}).register(new Class[]{RaftStorageConfig.class}).build();
        }

        @Override
        public ManagedPartitionGroup newPartitionGroup(RaftPartitionGroupConfig config) {
            return new RaftPartitionGroup(config);
        }

        public RaftPartitionGroupConfig newConfig() {
            return new RaftPartitionGroupConfig();
        }
    }
}

