/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition.impl;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.metrics.RaftStartupMetrics;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroupConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.partition.impl.RaftNamespaces;
import io.atomix.raft.partition.impl.RaftServerCommunicator;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.storage.StorageException;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.zeebe.snapshots.raft.PersistedSnapshotStore;
import io.zeebe.snapshots.raft.ReceivableSnapshotStore;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;

public class RaftPartitionServer
implements Managed<RaftPartitionServer> {
    private final Logger log;
    private final MemberId localMemberId;
    private final RaftPartition partition;
    private final RaftPartitionGroupConfig config;
    private final ClusterMembershipService membershipService;
    private final ClusterCommunicationService clusterCommunicator;
    private final Set<RaftRoleChangeListener> deferredRoleChangeListeners = new CopyOnWriteArraySet<RaftRoleChangeListener>();
    private final Set<Runnable> deferredFailureListeners = new CopyOnWriteArraySet<Runnable>();
    private RaftServer server;
    private ReceivableSnapshotStore persistedSnapshotStore;

    public RaftPartitionServer(RaftPartition partition, RaftPartitionGroupConfig config, MemberId localMemberId, ClusterMembershipService membershipService, ClusterCommunicationService clusterCommunicator) {
        this.partition = partition;
        this.config = config;
        this.localMemberId = localMemberId;
        this.membershipService = membershipService;
        this.clusterCommunicator = clusterCommunicator;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftPartitionServer.class).addValue((Object)partition.name()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftPartitionServer> start() {
        CompletableFuture<Object> serverOpenFuture;
        long bootstrapStartTime;
        RaftStartupMetrics raftStartupMetrics = new RaftStartupMetrics(this.partition.name());
        this.log.info("Starting server for partition {}", (Object)this.partition.id());
        long startTime = System.currentTimeMillis();
        if (this.partition.members().contains(this.localMemberId)) {
            if (this.server != null && this.server.isRunning()) {
                return CompletableFuture.completedFuture(null);
            }
            RaftPartitionServer raftPartitionServer = this;
            synchronized (raftPartitionServer) {
                try {
                    this.initServer();
                }
                catch (StorageException e2) {
                    return Futures.exceptionalFuture((Throwable)e2);
                }
            }
            bootstrapStartTime = System.currentTimeMillis();
            serverOpenFuture = this.server.bootstrap(this.partition.members());
        } else {
            bootstrapStartTime = System.currentTimeMillis();
            serverOpenFuture = CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)serverOpenFuture.whenComplete((r, e) -> {
            if (e == null) {
                long endTime = System.currentTimeMillis();
                long startDuration = endTime - startTime;
                raftStartupMetrics.observeBootstrapDuration(endTime - bootstrapStartTime);
                raftStartupMetrics.observeStartupDuration(startDuration);
                this.log.info("Successfully started server for partition {} in {}ms", (Object)this.partition.id(), (Object)startDuration);
            } else {
                this.log.warn("Failed to start server for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public CompletableFuture<Void> stop() {
        return this.server.shutdown();
    }

    private void initServer() {
        this.server = this.buildServer();
        if (!this.deferredRoleChangeListeners.isEmpty()) {
            this.deferredRoleChangeListeners.forEach(this.server::addRoleChangeListener);
            this.deferredRoleChangeListeners.clear();
        }
        if (!this.deferredFailureListeners.isEmpty()) {
            this.deferredFailureListeners.forEach(this.server::addFailureListener);
            this.deferredFailureListeners.clear();
        }
    }

    private RaftServer buildServer() {
        Integer partitionId = (Integer)this.partition.id().id();
        this.persistedSnapshotStore = this.config.getStorageConfig().getPersistedSnapshotStoreFactory().createReceivableSnapshotStore(this.partition.dataDirectory().toPath(), partitionId.intValue());
        return (RaftServer)RaftServer.builder(this.localMemberId).withName(this.partition.name()).withMembershipService(this.membershipService).withProtocol(this.createServerProtocol()).withHeartbeatInterval(this.config.getHeartbeatInterval()).withElectionTimeout(this.config.getElectionTimeout()).withMaxAppendBatchSize(this.config.getMaxAppendBatchSize()).withMaxAppendsPerFollower(this.config.getMaxAppendsPerFollower()).withStorage(this.createRaftStorage()).withEntryValidator(this.config.getEntryValidator()).build();
    }

    public CompletableFuture<Void> goInactive() {
        return this.server.goInactive();
    }

    public CompletableFuture<Void> snapshot() {
        return this.server.compact();
    }

    public void setCompactableIndex(long index) {
        this.server.getContext().getLogCompactor().setCompactableIndex(index);
    }

    public RaftLogReader openReader(long index, RaftLogReader.Mode mode) {
        return this.server.getContext().getLog().openReader(index, mode);
    }

    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        if (this.server == null) {
            this.deferredRoleChangeListeners.add(listener);
        } else {
            this.server.addRoleChangeListener(listener);
        }
    }

    public void addFailureListener(Runnable failureListener) {
        if (this.server == null) {
            this.deferredFailureListeners.add(failureListener);
        } else {
            this.server.addFailureListener(failureListener);
        }
    }

    public void removeFailureListener(Runnable failureListener) {
        this.server.removeFailureListener(failureListener);
    }

    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.deferredRoleChangeListeners.remove(listener);
        this.server.removeRoleChangeListener(listener);
    }

    public void addCommitListener(RaftCommitListener commitListener) {
        this.server.getContext().addCommitListener(commitListener);
    }

    public void removeCommitListener(RaftCommitListener commitListener) {
        this.server.getContext().removeCommitListener(commitListener);
    }

    public PersistedSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public void delete() {
        try {
            Files.walkFileTree(this.partition.dataDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error("Failed to delete partition: {}", (Object)this.partition, (Object)e);
        }
    }

    public Optional<ZeebeLogAppender> getAppender() {
        RaftRole role = this.server.getContext().getRaftRole();
        if (role instanceof ZeebeLogAppender) {
            return Optional.of((ZeebeLogAppender)((Object)role));
        }
        return Optional.empty();
    }

    public RaftServer.Role getRole() {
        return this.server.getRole();
    }

    public long getTerm() {
        return this.server.getTerm();
    }

    private RaftStorage createRaftStorage() {
        RaftStorageConfig storageConfig = this.config.getStorageConfig();
        return RaftStorage.builder().withPrefix(this.partition.name()).withDirectory(this.partition.dataDirectory()).withMaxSegmentSize((int)storageConfig.getSegmentSize().bytes()).withMaxEntrySize((int)storageConfig.getMaxEntrySize().bytes()).withFlushExplicitly(storageConfig.shouldFlushExplicitly()).withFreeDiskSpace(storageConfig.getFreeDiskSpace()).withNamespace(RaftNamespaces.RAFT_STORAGE).withSnapshotStore(this.persistedSnapshotStore).withJournalIndexDensity(storageConfig.getJournalIndexDensity()).build();
    }

    private RaftServerCommunicator createServerProtocol() {
        return new RaftServerCommunicator(this.partition.name(), Serializer.using((Namespace)RaftNamespaces.RAFT_PROTOCOL), this.clusterCommunicator);
    }

    public CompletableFuture<Void> stepDown() {
        return this.server.stepDown();
    }
}

