/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.RaftError;
import io.atomix.raft.protocol.AbstractRaftResponse;
import io.atomix.raft.protocol.RaftResponse;
import java.util.Objects;

public class PollResponse
extends AbstractRaftResponse {
    private final long term;
    private final boolean accepted;

    public PollResponse(RaftResponse.Status status, RaftError error, long term, boolean accepted) {
        super(status, error);
        this.term = term;
        this.accepted = accepted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public boolean accepted() {
        return this.accepted;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.term, this.accepted});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PollResponse) {
            PollResponse response = (PollResponse)object;
            return response.status == this.status && response.term == this.term && response.accepted == this.accepted;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("term", this.term).add("accepted", this.accepted).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, PollResponse> {
        private long term = -1L;
        private boolean accepted;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withAccepted(boolean accepted) {
            this.accepted = accepted;
            return this;
        }

        public PollResponse build() {
            this.validate();
            return new PollResponse(this.status, this.error, this.term, this.accepted);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            }
        }
    }
}

