/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.snapshot.impl;

import io.atomix.raft.snapshot.SbeBufferWriterReader;
import io.atomix.raft.snapshot.impl.SnapshotChunkDecoder;
import io.atomix.raft.snapshot.impl.SnapshotChunkEncoder;
import io.zeebe.snapshots.raft.SnapshotChunk;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class SnapshotChunkImpl
extends SbeBufferWriterReader<SnapshotChunkEncoder, SnapshotChunkDecoder>
implements SnapshotChunk {
    private final SnapshotChunkEncoder encoder = new SnapshotChunkEncoder();
    private final SnapshotChunkDecoder decoder = new SnapshotChunkDecoder();
    private final DirectBuffer content = new UnsafeBuffer(0L, 0);
    private String snapshotId;
    private int totalCount;
    private String chunkName;
    private long checksum;
    private long snapshotChecksum;

    public SnapshotChunkImpl() {
    }

    public SnapshotChunkImpl(SnapshotChunk chunk) {
        this.snapshotId = chunk.getSnapshotId();
        this.totalCount = chunk.getTotalCount();
        this.chunkName = chunk.getChunkName();
        this.checksum = chunk.getChecksum();
        this.snapshotChecksum = chunk.getSnapshotChecksum();
        this.content.wrap(chunk.getContent());
    }

    @Override
    protected SnapshotChunkEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected SnapshotChunkDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public void reset() {
        super.reset();
        this.totalCount = SnapshotChunkDecoder.totalCountNullValue();
        this.checksum = SnapshotChunkDecoder.checksumNullValue();
        this.snapshotChecksum = SnapshotChunkDecoder.snapshotChecksumNullValue();
        this.snapshotId = "";
        this.chunkName = "";
        this.content.wrap(0L, 0);
    }

    @Override
    public int getLength() {
        return super.getLength() + SnapshotChunkEncoder.snapshotIdHeaderLength() + this.snapshotId.length() + SnapshotChunkEncoder.chunkNameHeaderLength() + this.chunkName.length() + SnapshotChunkEncoder.contentHeaderLength() + this.content.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.totalCount(this.totalCount).snapshotId(this.snapshotId).chunkName(this.chunkName).checksum(this.checksum).snapshotChecksum(this.snapshotChecksum).putContent(this.content, 0, this.content.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.totalCount = this.decoder.totalCount();
        this.snapshotId = this.decoder.snapshotId();
        this.chunkName = this.decoder.chunkName();
        this.checksum = this.decoder.checksum();
        this.snapshotChecksum = this.decoder.snapshotChecksum();
        if (this.decoder.contentLength() > 0) {
            this.decoder.wrapContent(this.content);
        }
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public String getChunkName() {
        return this.chunkName;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public byte[] getContent() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.content);
    }

    public long getSnapshotChecksum() {
        return this.snapshotChecksum;
    }

    public String toString() {
        return "SnapshotChunkImpl{snapshotId=" + this.snapshotId + ", totalCount=" + this.totalCount + ", chunkName='" + this.chunkName + "', checksum=" + this.checksum + ", snapshotChecksum=" + this.snapshotChecksum + "} " + super.toString();
    }
}

