/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import com.google.common.base.MoreObjects;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.PersistedRaftRecord;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.zeebe.journal.JournalRecord;
import java.util.Objects;

class IndexedRaftLogEntryImpl
implements IndexedRaftLogEntry {
    private final long index;
    private final long term;
    private final RaftEntry entry;
    private final JournalRecord record;

    public IndexedRaftLogEntryImpl(long term, RaftEntry entry, JournalRecord record) {
        this.term = term;
        this.entry = entry;
        this.record = record;
        this.index = record.index();
    }

    @Override
    public long index() {
        return this.record.index();
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public RaftEntry entry() {
        return this.entry;
    }

    @Override
    public boolean isApplicationEntry() {
        return this.entry instanceof ApplicationEntry;
    }

    @Override
    public ApplicationEntry getApplicationEntry() {
        return (ApplicationEntry)this.entry;
    }

    @Override
    public PersistedRaftRecord getPersistedRaftRecord() {
        byte[] serializedRaftLogEntry = new byte[this.record.data().capacity()];
        this.record.data().getBytes(0, serializedRaftLogEntry);
        return new PersistedRaftRecord(this.term, this.index, this.record.asqn(), this.record.checksum(), serializedRaftLogEntry);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.term, this.entry, this.record);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedRaftLogEntryImpl that = (IndexedRaftLogEntryImpl)o;
        return this.index == that.index && this.term == that.term && this.record.asqn() == that.record.asqn() && this.record.checksum() == that.record.checksum() && Objects.equals(this.entry, that.entry);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("term", this.term).add("entry", (Object)this.entry).add("record", (Object)this.record).toString();
    }
}

