/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.IndexedRaftLogEntryImpl;
import io.atomix.raft.storage.log.PersistedRaftRecord;
import io.atomix.raft.storage.log.RaftEntrySBESerializer;
import io.atomix.raft.storage.log.RaftEntrySerializer;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.zeebe.journal.Journal;
import io.zeebe.journal.JournalRecord;
import io.zeebe.journal.file.SegmentedJournal;
import io.zeebe.journal.file.SegmentedJournalBuilder;
import java.io.Closeable;
import java.io.File;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RaftLog
implements Closeable {
    private final Journal journal;
    private final RaftEntrySerializer serializer = new RaftEntrySBESerializer();
    private final boolean flushExplicitly;
    private IndexedRaftLogEntry lastAppendedEntry;
    private volatile long commitIndex;
    private final MutableDirectBuffer writeBuffer = new ExpandableArrayBuffer(4096);

    protected RaftLog(Journal journal, boolean flushExplicitly) {
        this.journal = journal;
        this.flushExplicitly = flushExplicitly;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RaftLogReader openReader(long index) {
        return this.openReader(index, RaftLogReader.Mode.ALL);
    }

    public RaftLogReader openReader(long index, RaftLogReader.Mode mode) {
        RaftLogReader reader = new RaftLogReader(this, this.journal.openReader(), mode);
        reader.reset(index);
        return reader;
    }

    public boolean isOpen() {
        return this.journal.isOpen();
    }

    public void compact(long index) {
        this.journal.deleteUntil(index);
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void setCommitIndex(long index) {
        this.commitIndex = index;
    }

    public boolean shouldFlushExplicitly() {
        return this.flushExplicitly;
    }

    public long getFirstIndex() {
        return this.journal.getFirstIndex();
    }

    public long getLastIndex() {
        return this.journal.getLastIndex();
    }

    public IndexedRaftLogEntry getLastEntry() {
        if (this.lastAppendedEntry == null) {
            this.readLastEntry();
        }
        return this.lastAppendedEntry;
    }

    private void readLastEntry() {
        try (RaftLogReader reader = this.openReader(this.journal.getLastIndex());){
            if (reader.hasNext()) {
                this.lastAppendedEntry = reader.next();
            }
        }
    }

    public boolean isEmpty() {
        return this.journal.isEmpty();
    }

    public IndexedRaftLogEntry append(RaftLogEntry entry) {
        JournalRecord journalRecord;
        if (entry.isApplicationEntry()) {
            ApplicationEntry asqnEntry = entry.getApplicationEntry();
            int serializedLength = this.serializer.writeApplicationEntry(entry.term(), asqnEntry, this.writeBuffer, 0);
            journalRecord = this.journal.append(asqnEntry.lowestPosition(), (DirectBuffer)new UnsafeBuffer((DirectBuffer)this.writeBuffer, 0, serializedLength));
        } else if (entry.isInitialEntry()) {
            InitialEntry initialEntry = entry.getInitialEntry();
            int serializedLength = this.serializer.writeInitialEntry(entry.term(), initialEntry, this.writeBuffer, 0);
            journalRecord = this.journal.append((DirectBuffer)new UnsafeBuffer((DirectBuffer)this.writeBuffer, 0, serializedLength));
        } else if (entry.isConfigurationEntry()) {
            ConfigurationEntry configurationEntry = entry.getConfigurationEntry();
            int serializedLength = this.serializer.writeConfigurationEntry(entry.term(), configurationEntry, this.writeBuffer, 0);
            journalRecord = this.journal.append((DirectBuffer)new UnsafeBuffer((DirectBuffer)this.writeBuffer, 0, serializedLength));
        } else {
            throw new IllegalArgumentException("Unexpected entry type " + entry);
        }
        this.lastAppendedEntry = new IndexedRaftLogEntryImpl(entry.term(), entry.entry(), journalRecord);
        return this.lastAppendedEntry;
    }

    public IndexedRaftLogEntry append(PersistedRaftRecord entry) {
        this.journal.append((JournalRecord)entry);
        RaftLogEntry raftEntry = this.serializer.readRaftLogEntry(entry.data());
        this.lastAppendedEntry = new IndexedRaftLogEntryImpl(entry.term(), raftEntry.entry(), entry);
        return this.lastAppendedEntry;
    }

    public void reset(long index) {
        this.journal.reset(index);
        this.lastAppendedEntry = null;
    }

    public void truncate(long index) {
        this.journal.deleteAfter(index);
        this.lastAppendedEntry = null;
    }

    public void flush() {
        if (this.flushExplicitly) {
            this.journal.flush();
        }
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.journal);
    }

    public String toString() {
        return "RaftLog{journal=" + this.journal + ", serializer=" + this.serializer + ", flushExplicitly=" + this.flushExplicitly + ", lastWrittenEntry=" + this.lastAppendedEntry + ", commitIndex=" + this.commitIndex + "}";
    }

    public static class Builder
    implements io.atomix.utils.Builder<RaftLog> {
        private final SegmentedJournalBuilder journalBuilder = SegmentedJournal.builder();
        private boolean flushExplicitly = true;

        protected Builder() {
        }

        public Builder withName(String name) {
            this.journalBuilder.withName(name);
            return this;
        }

        public Builder withDirectory(String directory) {
            this.journalBuilder.withDirectory(directory);
            return this;
        }

        public Builder withDirectory(File directory) {
            this.journalBuilder.withDirectory(directory);
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.journalBuilder.withMaxSegmentSize(maxSegmentSize);
            return this;
        }

        public Builder withMaxEntrySize(int maxEntrySize) {
            this.journalBuilder.withMaxEntrySize(maxEntrySize);
            return this;
        }

        public Builder withFreeDiskSpace(long freeDiskSpace) {
            this.journalBuilder.withFreeDiskSpace(freeDiskSpace);
            return this;
        }

        public Builder withFlushExplicitly(boolean flushExplicitly) {
            this.flushExplicitly = flushExplicitly;
            return this;
        }

        public Builder withJournalIndexDensity(int journalIndexDensity) {
            this.journalBuilder.withJournalIndexDensity(journalIndexDensity);
            return this;
        }

        public RaftLog build() {
            SegmentedJournal journal = this.journalBuilder.build();
            return new RaftLog((Journal)journal, this.flushExplicitly);
        }
    }
}

