/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log.entry;

import io.atomix.raft.storage.log.entry.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ApplicationEntryDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ApplicationEntryDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ApplicationEntryDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int lowestAsqnId() {
        return 0;
    }

    public static int lowestAsqnSinceVersion() {
        return 0;
    }

    public static int lowestAsqnEncodingOffset() {
        return 0;
    }

    public static int lowestAsqnEncodingLength() {
        return 8;
    }

    public static String lowestAsqnMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lowestAsqnNullValue() {
        return -1L;
    }

    public static long lowestAsqnMinValue() {
        return 0L;
    }

    public static long lowestAsqnMaxValue() {
        return -2L;
    }

    public long lowestAsqn() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int highestAsqnId() {
        return 1;
    }

    public static int highestAsqnSinceVersion() {
        return 0;
    }

    public static int highestAsqnEncodingOffset() {
        return 8;
    }

    public static int highestAsqnEncodingLength() {
        return 8;
    }

    public static String highestAsqnMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long highestAsqnNullValue() {
        return -1L;
    }

    public static long highestAsqnMinValue() {
        return 0L;
    }

    public static long highestAsqnMaxValue() {
        return -2L;
    }

    public long highestAsqn() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int applicationDataId() {
        return 2;
    }

    public static int applicationDataSinceVersion() {
        return 0;
    }

    public static String applicationDataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int applicationDataHeaderLength() {
        return 4;
    }

    public int applicationDataLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipApplicationData() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getApplicationData(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getApplicationData(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapApplicationData(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ApplicationEntryDecoder decoder = new ApplicationEntryDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ApplicationEntry](sbeTemplateId=");
        builder.append(2);
        builder.append("|sbeSchemaId=");
        builder.append(8);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("lowestAsqn=");
        builder.append(this.lowestAsqn());
        builder.append('|');
        builder.append("highestAsqn=");
        builder.append(this.highestAsqn());
        builder.append('|');
        builder.append("applicationData=");
        builder.append(this.skipApplicationData()).append(" bytes of raw data");
        this.limit(originalLimit);
        return builder;
    }
}

