/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import com.jayway.jsonpath.spi.cache.Cache;
import com.jayway.jsonpath.spi.cache.CacheProvider;
import com.jayway.jsonpath.spi.cache.NOOPCache;
import io.zeebe.msgpack.benchmark.JaywayJsonPathProcessor;
import io.zeebe.msgpack.benchmark.JsonConversionMsgPackJsonPathProcessor;
import io.zeebe.msgpack.benchmark.JsonGenerator;
import io.zeebe.msgpack.benchmark.JsonPathProcessor;
import io.zeebe.msgpack.benchmark.MsgPackConverter;
import io.zeebe.msgpack.benchmark.MsgPackJaywayJsonPathProcessor;
import io.zeebe.msgpack.benchmark.MsgPackJsonPathProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Random;

public class JsonBenchmark {
    protected static final JsonPathProcessor[] JSON_PATH_JSON_PROCESSORS;
    protected static final JsonPathProcessor[] JSON_PATH_MSGPACK_PROCESSORS;
    protected static MsgPackConverter converter;

    public static void main(String[] args) throws Exception {
        int levelsOfNesting = 6;
        int numValuesPerLevel = 10;
        JsonGenerator generator = new JsonGenerator(5, 10);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        generator.generate(outStream);
        byte[] json = outStream.toByteArray();
        System.out.println("Size: " + json.length);
        String jsonPathExpression = JsonBenchmark.generateJsonPathExpression(6, 10);
        System.out.println(jsonPathExpression);
        long[] jsonBasedResults = JsonBenchmark.runBenchmark(json, jsonPathExpression, JSON_PATH_JSON_PROCESSORS);
        byte[] msgPack = converter.convertToMsgPack(new ByteArrayInputStream(json));
        long[] msgPackBasedResults = JsonBenchmark.runBenchmark(msgPack, jsonPathExpression, JSON_PATH_MSGPACK_PROCESSORS);
        System.out.println("Benchmark results:");
        JsonBenchmark.printResults(jsonBasedResults, JSON_PATH_JSON_PROCESSORS);
        JsonBenchmark.printResults(msgPackBasedResults, JSON_PATH_MSGPACK_PROCESSORS);
    }

    protected static long[] runBenchmark(byte[] data, String jsonPath, JsonPathProcessor[] processors) throws Exception {
        long[] results = new long[processors.length];
        for (int i = 0; i < processors.length; ++i) {
            JsonPathProcessor processor = processors[i];
            long startTime = System.currentTimeMillis();
            String result = processor.evaluateJsonPath(data, jsonPath);
            long endTime = System.currentTimeMillis();
            results[i] = endTime - startTime;
            System.out.println(result);
            System.gc();
            System.gc();
            System.gc();
        }
        return results;
    }

    protected static void printResults(long[] results, JsonPathProcessor[] processors) {
        for (int i = 0; i < processors.length; ++i) {
            System.out.println(processors[i].getClass().getSimpleName() + ": " + results[i] + " ms");
        }
    }

    protected static String generateJsonPathExpression(int levelsOfNesting, int numValuesPerLevel) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        sb.append("$");
        for (int i = 0; i < levelsOfNesting; ++i) {
            sb.append(".");
            sb.append((char)(r.nextInt(numValuesPerLevel) + 65));
        }
        return sb.toString();
    }

    static {
        CacheProvider.setCache((Cache)new NOOPCache());
        JSON_PATH_JSON_PROCESSORS = new JsonPathProcessor[]{new JaywayJsonPathProcessor(), new JsonConversionMsgPackJsonPathProcessor()};
        JSON_PATH_MSGPACK_PROCESSORS = new JsonPathProcessor[]{new MsgPackJaywayJsonPathProcessor(), new MsgPackJsonPathProcessor()};
        converter = new MsgPackConverter();
    }
}

