/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MsgPackConverter {
    protected static final JsonEncoding JSON_ENCODING = JsonEncoding.UTF8;
    protected static final Charset JSON_CHARSET = StandardCharsets.UTF_8;
    protected final JsonFactory msgPackFactory = new MessagePackFactory();
    protected final JsonFactory jsonFactory = new MappingJsonFactory();

    public byte[] convertToMsgPack(String json) {
        byte[] jsonBytes = json.getBytes(JSON_CHARSET);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonBytes);
        return this.convertToMsgPack(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] convertToMsgPack(InputStream inputStream) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.convert(inputStream, outputStream, this.jsonFactory, this.msgPackFactory);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert JSON to MessagePack", e);
        }
    }

    public String convertToJson(byte[] msgPack) {
        byte[] jsonBytes = this.convertToJsonBytes(msgPack);
        return new String(jsonBytes, JSON_CHARSET);
    }

    public InputStream convertToJsonInputStream(byte[] msgPack) {
        byte[] jsonBytes = this.convertToJsonBytes(msgPack);
        return new ByteArrayInputStream(jsonBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] convertToJsonBytes(byte[] msgPack) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(msgPack);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] jsonBytes;
            this.convert(inputStream, outputStream, this.msgPackFactory, this.jsonFactory);
            byte[] byArray = jsonBytes = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert MessagePack to JSON", e);
        }
    }

    protected void convert(InputStream in, OutputStream out, JsonFactory inFormat, JsonFactory outFormat) throws Exception {
        JsonParser parser = inFormat.createParser(in);
        JsonGenerator generator = outFormat.createGenerator(out, JSON_ENCODING);
        JsonToken token = parser.nextToken();
        if (token != JsonToken.START_OBJECT && token != JsonToken.START_ARRAY) {
            throw new RuntimeException("Document does not begin with an object or array");
        }
        generator.copyCurrentStructure(parser);
        if (parser.nextToken() != null) {
            throw new RuntimeException("Document has more content than a single object/array");
        }
        generator.flush();
    }
}

