/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import io.zeebe.msgpack.benchmark.JsonGenerator;
import io.zeebe.msgpack.benchmark.MsgPackConverter;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MsgPackDocumentExtractor;
import io.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Random;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackDocumentExtractorBenchmark {
    protected static MsgPackConverter converter = new MsgPackConverter();
    protected static final int LEVELS_OF_NESTING = 5;
    protected static final int NUM_VALUES_PER_LEVEL = 12;
    protected static final int RUN_COUNT = 100;
    protected static final int MAPPING_COUNT = 5;

    public static void main(String[] args) throws Exception {
        System.out.println("== Init extractor test ==");
        JsonGenerator generator = new JsonGenerator(4, 12);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        generator.generate(outStream);
        byte[] json = outStream.toByteArray();
        Mapping[] mappings = MsgPackDocumentExtractorBenchmark.generateMappings(5, 5, 12);
        byte[] msgPack = converter.convertToMsgPack(new ByteArrayInputStream(json));
        System.out.println(String.format("Message pack document size %d bytes.", msgPack.length));
        UnsafeBuffer sourceDocument = new UnsafeBuffer(msgPack);
        MsgPackDocumentExtractor extractor = new MsgPackDocumentExtractor();
        System.out.println();
        System.out.println("== Start extract test ==");
        long avgDiff = 0L;
        long maxDiff = 0L;
        long minDiff = Long.MAX_VALUE;
        for (int i = 0; i < 100; ++i) {
            extractor.wrap((DirectBuffer)sourceDocument);
            long startExtract = System.currentTimeMillis();
            extractor.extract(mappings);
            long endExtract = System.currentTimeMillis();
            long diff = endExtract - startExtract;
            avgDiff += diff;
            maxDiff = Math.max(maxDiff, diff);
            minDiff = Math.min(minDiff, diff);
        }
        System.out.println(String.format("Tests are run %d times.", 100));
        System.out.println(String.format("Extract avg execution time: %d ms", avgDiff /= 100L));
        System.out.println(String.format("Extract min execution time: %d ms", minDiff));
        System.out.println(String.format("Extract max execution time: %d ms", maxDiff));
    }

    protected static Mapping[] generateMappings(int mappingCount, int levelsOfNesting, int numValuesPerLevel) {
        JsonPathQuery rootSourceQuery = new JsonPathQueryCompiler().compile("$");
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (int i = 0; i < mappingCount; ++i) {
            mappings.add(new Mapping(rootSourceQuery, BufferUtil.wrapString((String)MsgPackDocumentExtractorBenchmark.generateJsonPathExpression(levelsOfNesting, numValuesPerLevel))));
        }
        return mappings.toArray(new Mapping[mappingCount]);
    }

    private static String generateJsonPathExpression(int levelsOfNesting, int numValuesPerLevel) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        sb.append("$");
        for (int i = 0; i < levelsOfNesting; ++i) {
            sb.append(".");
            sb.append((char)(r.nextInt(numValuesPerLevel) + 65));
        }
        return sb.toString();
    }
}

