/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import io.zeebe.msgpack.benchmark.JsonGenerator;
import io.zeebe.msgpack.benchmark.MsgPackConverter;
import io.zeebe.msgpack.mapping.MsgPackDocumentIndexer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackDocumentIndexerBenchmark {
    protected static MsgPackConverter converter = new MsgPackConverter();
    protected static final int LEVELS_OF_NESTING = 5;
    protected static final int NUM_VALUES_PER_LEVEL = 12;
    protected static final int RUN_COUNT = 100;

    public static void main(String[] args) throws Exception {
        System.out.println("== Init index test ==");
        JsonGenerator generator = new JsonGenerator(4, 12);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        generator.generate(outStream);
        byte[] json = outStream.toByteArray();
        byte[] msgPack = converter.convertToMsgPack(new ByteArrayInputStream(json));
        System.out.println(String.format("Message pack document size %d bytes.", msgPack.length));
        UnsafeBuffer sourceDocument = new UnsafeBuffer(msgPack);
        MsgPackDocumentIndexer indexer = new MsgPackDocumentIndexer();
        System.out.println();
        System.out.println("== Start index test ==");
        long avgDiff = 0L;
        long maxDiff = 0L;
        long minDiff = Long.MAX_VALUE;
        for (int i = 0; i < 100; ++i) {
            indexer.wrap((DirectBuffer)sourceDocument);
            long startIndex = System.currentTimeMillis();
            indexer.index();
            long endIndex = System.currentTimeMillis();
            long diff = endIndex - startIndex;
            avgDiff += diff;
            maxDiff = Math.max(maxDiff, diff);
            minDiff = Math.min(minDiff, diff);
        }
        System.out.println(String.format("Tests are run %d times.", 100));
        System.out.println(String.format("Index avg execution time: %d ms", avgDiff /= 100L));
        System.out.println(String.format("Index min execution time: %d ms", minDiff));
        System.out.println(String.format("Index max execution time: %d ms", maxDiff));
    }
}

