/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import io.zeebe.msgpack.benchmark.JsonGenerator;
import io.zeebe.msgpack.benchmark.MsgPackConverter;
import io.zeebe.msgpack.mapping.MsgPackDocumentIndexer;
import io.zeebe.msgpack.mapping.MsgPackDocumentTreeWriter;
import io.zeebe.msgpack.mapping.MsgPackTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackDocumentTreeWriterBenchmark {
    protected static MsgPackConverter converter = new MsgPackConverter();
    protected static final int LEVELS_OF_NESTING = 5;
    protected static final int NUM_VALUES_PER_LEVEL = 12;
    protected static final int RUN_COUNT = 100;

    public static void main(String[] args) throws Exception {
        System.out.println("== Init write tree test ==");
        JsonGenerator generator = new JsonGenerator(4, 12);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        generator.generate(outStream);
        byte[] json = outStream.toByteArray();
        byte[] msgPack = converter.convertToMsgPack(new ByteArrayInputStream(json));
        System.out.println(String.format("Message pack document size %d bytes.", msgPack.length));
        UnsafeBuffer sourceDocument = new UnsafeBuffer(msgPack);
        MsgPackDocumentIndexer indexer = new MsgPackDocumentIndexer();
        indexer.wrap((DirectBuffer)sourceDocument);
        MsgPackTree msgPackTree = indexer.index();
        MsgPackDocumentTreeWriter writer = new MsgPackDocumentTreeWriter(1024);
        System.out.println();
        System.out.println("== Start write tree test ==");
        long avgDiff = 0L;
        long maxDiff = 0L;
        long minDiff = Long.MAX_VALUE;
        long avgWrittenBytes = 0L;
        for (int i = 0; i < 100; ++i) {
            long startWrite = System.currentTimeMillis();
            int resultLen = writer.write(msgPackTree);
            long endWrite = System.currentTimeMillis();
            long diff = endWrite - startWrite;
            avgDiff += diff;
            avgWrittenBytes += (long)resultLen;
            maxDiff = Math.max(maxDiff, diff);
            minDiff = Math.min(minDiff, diff);
        }
        System.out.println(String.format("Tests are run %d times.", 100));
        System.out.println(String.format("AVG written bytes: %d", avgWrittenBytes /= 100L));
        System.out.println();
        System.out.println(String.format("Write avg execution time: %d ms", avgDiff /= 100L));
        System.out.println(String.format("Write min execution time: %d ms", minDiff));
        System.out.println(String.format("Write max execution time: %d ms", maxDiff));
    }
}

