/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.zeebe.msgpack.benchmark.JsonPathProcessor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MsgPackJaywayJsonPathProcessor
implements JsonPathProcessor {
    protected Configuration jacksonConfig;

    public MsgPackJaywayJsonPathProcessor() {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        this.jacksonConfig = Configuration.defaultConfiguration().mappingProvider((MappingProvider)new JacksonMappingProvider(objectMapper)).jsonProvider((JsonProvider)new CustomJacksonJsonProvider(objectMapper));
    }

    @Override
    public String evaluateJsonPath(byte[] msgPack, String jsonPath) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(msgPack);
        JsonPath query = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        Object result = query.read((InputStream)inputStream, this.jacksonConfig);
        return result.toString();
    }

    protected static class CustomJacksonJsonProvider
    extends JacksonJsonProvider {
        public CustomJacksonJsonProvider(ObjectMapper o) {
            super(o);
        }

        public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
            try {
                return this.objectReader.readValue(jsonStream);
            }
            catch (Exception e) {
                throw new InvalidJsonException((Throwable)e);
            }
        }
    }
}

