/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.benchmark;

import io.zeebe.msgpack.benchmark.JsonPathProcessor;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import io.zeebe.msgpack.query.MsgPackQueryExecutor;
import io.zeebe.msgpack.query.MsgPackTokenVisitor;
import io.zeebe.msgpack.query.MsgPackTraverser;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

public class MsgPackJsonPathProcessor
implements JsonPathProcessor {
    protected JsonPathQueryCompiler queryCompiler = new JsonPathQueryCompiler();
    protected MsgPackTraverser traverser = new MsgPackTraverser();
    protected MsgPackQueryExecutor queryExecutor = new MsgPackQueryExecutor();
    protected UnsafeBuffer msgPackBuffer = new UnsafeBuffer(0L, 0);

    @Override
    public String evaluateJsonPath(byte[] msgPack, String jsonPath) throws Exception {
        this.msgPackBuffer.wrap(msgPack);
        JsonPathQuery query = this.queryCompiler.compile(jsonPath);
        this.queryExecutor.init(query.getFilters(), query.getFilterInstances());
        this.traverser.wrap((DirectBuffer)this.msgPackBuffer, 0, this.msgPackBuffer.capacity());
        this.traverser.traverse((MsgPackTokenVisitor)this.queryExecutor);
        this.queryExecutor.moveToResult(0);
        int resultLength = this.queryExecutor.currentResultLength();
        byte[] result = new byte[resultLength];
        System.arraycopy(msgPack, this.queryExecutor.currentResultPosition(), result, 0, resultLength);
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])result);
        return Integer.toString(unpacker.unpackInt());
    }
}

