/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util;

import io.zeebe.test.util.BufferReaderMatch;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;

public class BufferWriterMatcher<T extends BufferReader>
extends ArgumentMatcher<BufferWriter> {
    protected T reader;
    protected List<BufferReaderMatch<T>> propertyMatchers = new ArrayList<BufferReaderMatch<T>>();

    public BufferWriterMatcher(T reader) {
        this.reader = reader;
    }

    public boolean matches(Object argument) {
        if (argument == null || !(argument instanceof BufferWriter)) {
            return false;
        }
        BufferWriter writer = (BufferWriter)argument;
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[writer.getLength()]);
        writer.write((MutableDirectBuffer)buffer, 0);
        this.reader.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        for (BufferReaderMatch<T> matcher : this.propertyMatchers) {
            if (matcher.matches(this.reader)) continue;
            return false;
        }
        return true;
    }

    public BufferWriterMatcher<T> matching(Function<T, Object> actualProperty, Object expectedValue) {
        BufferReaderMatch match = new BufferReaderMatch();
        match.propertyExtractor = actualProperty;
        if (expectedValue instanceof Matcher) {
            match.expectedValueMatcher = (Matcher)expectedValue;
        } else {
            match.expectedValue = expectedValue;
        }
        this.propertyMatchers.add(match);
        return this;
    }

    public static <T extends BufferReader> BufferWriterMatcher<T> writesProperties(Class<T> readerClass) {
        try {
            BufferWriterMatcher<BufferReader> matcher = new BufferWriterMatcher<BufferReader>((BufferReader)readerClass.newInstance());
            return matcher;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct matcher", e);
        }
    }
}

