/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.agent;

import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorReferenceImpl;
import io.zeebe.util.actor.ActorScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.rules.ExternalResource;

public class ControllableTaskScheduler
extends ExternalResource
implements ActorScheduler {
    protected static final int MAX_WORK_COUNT = 1000000;
    protected AtomicBoolean isRunning = new AtomicBoolean(true);
    protected final List<ActorReferenceImpl> actorRefs = new ArrayList<ActorReferenceImpl>();

    protected void after() {
        this.waitUntilDone();
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int waitUntilDone() {
        int totalWorkCount = 0;
        if (this.isRunning.get()) {
            int workCount;
            do {
                workCount = 0;
                ArrayList<ActorReferenceImpl> actorRefList = new ArrayList<ActorReferenceImpl>(this.actorRefs);
                for (int i = 0; i < actorRefList.size() && this.isRunning.get(); ++i) {
                    ActorReferenceImpl actorRef = actorRefList.get(i);
                    if (actorRef == null) continue;
                    try {
                        workCount += actorRef.getActor().doWork();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((totalWorkCount += workCount) <= 1000000) continue;
                throw new RuntimeException("work count limit of agent runner service exceeded");
            } while (workCount > 0);
        }
        return totalWorkCount;
    }

    public void close() {
        this.isRunning.set(false);
    }

    public synchronized ActorReference schedule(Actor actor) {
        ActorReferenceImpl scheduledTask = new ActorReferenceImpl(actor, 32);
        this.actorRefs.add(scheduledTask);
        return scheduledTask;
    }
}

