/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.collection;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class MapFactoryBuilder<A, T> {
    protected T returnValue;
    protected Consumer<Function<A, Map<String, Object>>> factoryCallback;
    protected BiConsumer<A, Map<String, Object>> manipulationChain = (a, m) -> {};

    public MapFactoryBuilder(T returnValue, Consumer<Function<A, Map<String, Object>>> factoryCallback) {
        this.returnValue = returnValue;
        this.factoryCallback = factoryCallback;
    }

    public MapFactoryBuilder<A, T> allOf(Function<A, Map<String, Object>> otherMap) {
        this.manipulationChain = this.manipulationChain.andThen((a, m) -> m.putAll((Map)otherMap.apply(a)));
        return this;
    }

    public MapFactoryBuilder<A, T> put(String key, Object value) {
        this.manipulationChain = this.manipulationChain.andThen((a, m) -> m.put(key, value));
        return this;
    }

    public MapFactoryBuilder<A, T> put(String key, Function<A, Object> valueFunction) {
        this.manipulationChain = this.manipulationChain.andThen((a, m) -> m.put(key, valueFunction.apply(a)));
        return this;
    }

    public T done() {
        this.factoryCallback.accept(a -> {
            HashMap map = new HashMap();
            this.manipulationChain.accept(a, map);
            return map;
        });
        return this.returnValue;
    }
}

