/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.io;

import java.io.IOException;
import java.io.InputStream;

public class RepeatedlyFailingInputStream
extends InputStream {
    public static final long DEFAULT_FAILURE_FREQUENCY = 8L;
    private final InputStream underlyingInputStream;
    private final long failureFrequency;
    private long readCount;

    public RepeatedlyFailingInputStream(InputStream underlyingInputStream) {
        this(underlyingInputStream, 8L);
    }

    public RepeatedlyFailingInputStream(InputStream underlyingInputStream, long failureFrequency) {
        this.underlyingInputStream = underlyingInputStream;
        this.failureFrequency = failureFrequency;
        this.readCount = 0L;
    }

    @Override
    public int read() throws IOException {
        ++this.readCount;
        if (this.readCount % this.failureFrequency == 0L) {
            throw new IOException("Read failure - try again");
        }
        return this.underlyingInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readCount = 0L;
        return super.read(b, off, len);
    }
}

