/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.io;

import java.io.IOException;
import java.io.InputStream;

public class ShortReadInputStream
extends InputStream {
    public static final int END_OF_STREAM = -1;
    private final InputStream underlyingInputStream;
    private final long bytesToRead;
    private final boolean throwException;
    private long readCount;

    public ShortReadInputStream(InputStream underlyingInputStream, long bytesToRead, boolean throwException) {
        this.underlyingInputStream = underlyingInputStream;
        this.bytesToRead = bytesToRead;
        this.throwException = throwException;
        this.readCount = 0L;
    }

    @Override
    public int read() throws IOException {
        ++this.readCount;
        if (this.readCount > this.bytesToRead) {
            if (this.throwException) {
                throw new IOException("Read failure");
            }
            return -1;
        }
        return this.underlyingInputStream.read();
    }
}

