/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.ClusterComponent;
import io.zeebe.broker.logstreams.LogStreamsComponent;
import io.zeebe.broker.system.SystemComponent;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.task.TaskQueueComponent;
import io.zeebe.broker.transport.TransportComponent;
import io.zeebe.broker.workflow.WorkflowComponent;
import java.io.InputStream;
import org.slf4j.Logger;

public class Broker
implements AutoCloseable {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    protected final SystemContext brokerContext;

    public Broker(String configFileLocation) {
        this.brokerContext = new SystemContext(configFileLocation);
        this.start();
    }

    public Broker(InputStream configStream) {
        this.brokerContext = new SystemContext(configStream);
        this.start();
    }

    protected void start() {
        this.brokerContext.addComponent(new SystemComponent());
        this.brokerContext.addComponent(new TransportComponent());
        this.brokerContext.addComponent(new LogStreamsComponent());
        this.brokerContext.addComponent(new TaskQueueComponent());
        this.brokerContext.addComponent(new WorkflowComponent());
        this.brokerContext.addComponent(new ClusterComponent());
        this.brokerContext.init();
    }

    @Override
    public void close() {
        this.brokerContext.close();
        LOG.info("Broker closed");
    }

    public SystemContext getBrokerContext() {
        return this.brokerContext;
    }
}

