/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering;

import io.zeebe.broker.clustering.ClusterServiceNames;
import io.zeebe.broker.clustering.gossip.service.GossipContextService;
import io.zeebe.broker.clustering.gossip.service.GossipService;
import io.zeebe.broker.clustering.gossip.service.LocalPeerService;
import io.zeebe.broker.clustering.gossip.service.PeerListService;
import io.zeebe.broker.clustering.gossip.service.PeerSelectorService;
import io.zeebe.broker.clustering.management.service.ClusterManagerContextService;
import io.zeebe.broker.clustering.management.service.ClusterManagerService;
import io.zeebe.broker.logstreams.LogStreamServiceNames;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.broker.transport.TransportServiceNames;
import io.zeebe.broker.transport.cfg.SocketBindingCfg;
import io.zeebe.broker.transport.cfg.TransportComponentCfg;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.transport.SocketAddress;

public class ClusterComponent
implements Component {
    public static final String WORKER_NAME = "management-worker.0";

    @Override
    public void init(SystemContext context) {
        ServiceContainer serviceContainer = context.getServiceContainer();
        ConfigurationManager configurationManager = context.getConfigurationManager();
        TransportComponentCfg config = configurationManager.readEntry("network", TransportComponentCfg.class);
        this.initLocalPeer(serviceContainer, config);
        this.initPeers(serviceContainer, config);
        this.initGossip(serviceContainer, config);
        this.initClusterManager(serviceContainer, config);
    }

    protected void initLocalPeer(ServiceContainer serviceContainer, TransportComponentCfg config) {
        SocketAddress clientEndpoint = this.createEndpoint(config, config.clientApi);
        SocketAddress managementEndpoint = this.createEndpoint(config, config.managementApi);
        SocketAddress replicationEndpoint = this.createEndpoint(config, config.replicationApi);
        LocalPeerService localPeerService = new LocalPeerService(clientEndpoint, managementEndpoint, replicationEndpoint);
        serviceContainer.createService(ClusterServiceNames.PEER_LOCAL_SERVICE, (Service)localPeerService).install();
    }

    protected void initPeers(ServiceContainer serviceContainer, TransportComponentCfg config) {
        PeerListService peersService = new PeerListService(config.gossip);
        serviceContainer.createService(ClusterServiceNames.PEER_LIST_SERVICE, (Service)peersService).dependency(ClusterServiceNames.PEER_LOCAL_SERVICE, peersService.getLocalPeerInjector()).install();
    }

    protected void initGossip(ServiceContainer serviceContainer, TransportComponentCfg config) {
        PeerSelectorService peerSelectorService = new PeerSelectorService();
        serviceContainer.createService(ClusterServiceNames.GOSSIP_PEER_SELECTOR_SERVICE, (Service)peerSelectorService).dependency(ClusterServiceNames.PEER_LIST_SERVICE, peerSelectorService.getPeerListInjector()).install();
        GossipContextService gossipContextService = new GossipContextService(config.gossip);
        serviceContainer.createService(ClusterServiceNames.GOSSIP_CONTEXT_SERVICE, (Service)gossipContextService).dependency(ClusterServiceNames.PEER_LIST_SERVICE, gossipContextService.getPeerListInjector()).dependency(ClusterServiceNames.PEER_LOCAL_SERVICE, gossipContextService.getLocalPeerInjector()).dependency(ClusterServiceNames.GOSSIP_PEER_SELECTOR_SERVICE, gossipContextService.getPeerSelectorInjector()).dependency(TransportServiceNames.clientTransport("managementApi.client"), gossipContextService.getClientTransportInjector()).dependency(TransportServiceNames.bufferingServerTransport("managementApi.server"), gossipContextService.getManagementApiTransportInjector()).install();
        GossipService gossipService = new GossipService();
        serviceContainer.createService(ClusterServiceNames.GOSSIP_SERVICE, (Service)gossipService).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, gossipService.getActorSchedulerInjector()).dependency(ClusterServiceNames.GOSSIP_CONTEXT_SERVICE, gossipService.getGossipContextInjector()).install();
    }

    protected void initClusterManager(ServiceContainer serviceContainer, TransportComponentCfg config) {
        ClusterManagerContextService clusterManagementContextService = new ClusterManagerContextService();
        serviceContainer.createService(ClusterServiceNames.CLUSTER_MANAGER_CONTEXT_SERVICE, (Service)clusterManagementContextService).dependency(TransportServiceNames.bufferingServerTransport("managementApi.server"), clusterManagementContextService.getManagementApiTransportInjector()).dependency(TransportServiceNames.clientTransport("managementApi.client"), clusterManagementContextService.getClientTransportInjector()).dependency(ClusterServiceNames.PEER_LIST_SERVICE, clusterManagementContextService.getPeerListInjector()).dependency(ClusterServiceNames.PEER_LOCAL_SERVICE, clusterManagementContextService.getLocalPeerInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, clusterManagementContextService.getActorSchedulerInjector()).dependency(LogStreamServiceNames.LOG_STREAMS_MANAGER_SERVICE, clusterManagementContextService.getLogStreamsManagerInjector()).install();
        ClusterManagerService clusterManagerService = new ClusterManagerService(serviceContainer, config.management);
        serviceContainer.createService(ClusterServiceNames.CLUSTER_MANAGER_SERVICE, (Service)clusterManagerService).dependency(ClusterServiceNames.CLUSTER_MANAGER_CONTEXT_SERVICE, clusterManagerService.getClusterManagementContextInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, clusterManagerService.getActorSchedulerInjector()).groupReference(ClusterServiceNames.RAFT_SERVICE_GROUP, clusterManagerService.getRaftGroupReference()).install();
    }

    protected SocketAddress createEndpoint(TransportComponentCfg config, SocketBindingCfg socketConfig) {
        int port = socketConfig.getPort();
        String host = socketConfig.getHost(config.host);
        SocketAddress endpoint = new SocketAddress();
        endpoint.host(host).port(port);
        return new SocketAddress().host(host).port(port);
    }
}

