/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.PeerListIterator;
import io.zeebe.broker.clustering.gossip.data.RaftMembership;
import io.zeebe.broker.clustering.gossip.handler.GossipFragmentHandler;
import io.zeebe.broker.clustering.gossip.protocol.GossipController;
import io.zeebe.broker.clustering.handler.BrokerAddress;
import io.zeebe.broker.clustering.handler.TopicLeader;
import io.zeebe.broker.clustering.handler.Topology;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.clustering.gossip.RaftMembershipState;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.ServerInputSubscription;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.DeferredCommandContext;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.buffer.BufferUtil;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;

public class Gossip
implements Actor {
    public static final String GOSSIP_FILE_NAME = "gossip.zeebe";
    private final Peer peer;
    private final PeerList peers;
    protected final ServerInputSubscription inputSubscription;
    private final GossipController gossipController;
    private final DeferredCommandContext commandContext;

    public Gossip(GossipContext context) {
        this.peer = context.getLocalPeer();
        this.peers = context.getPeers();
        this.gossipController = new GossipController(context);
        BufferingServerTransport serverTransport = context.getServerTransport();
        GossipFragmentHandler fragmentHandler = new GossipFragmentHandler(this.gossipController);
        this.inputSubscription = (ServerInputSubscription)serverTransport.openSubscription("gossip", (ServerMessageHandler)fragmentHandler, (ServerRequestHandler)fragmentHandler).join();
        this.commandContext = new DeferredCommandContext();
    }

    public String name() {
        return "gossip";
    }

    public int getPriority(long now) {
        return 1;
    }

    public void open() {
        PeerListIterator iterator = this.peers.iterator();
        while (iterator.hasNext()) {
            Peer peer = iterator.next();
            if (peer.state() == PeerState.SUSPECT) {
                peer.state(PeerState.ALIVE);
            }
            this.peers.set(iterator.position(), peer);
        }
        this.gossipController.open();
    }

    public void close() {
        this.gossipController.close();
    }

    public int doWork() throws Exception {
        int workcount = 0;
        workcount += this.commandContext.doWork();
        workcount += this.gossipController.doWork();
        return workcount += this.inputSubscription.poll();
    }

    public Peer peer() {
        return this.peer;
    }

    public PeerList peers() {
        return this.peers;
    }

    public static String fileName(String directory) {
        return directory + GOSSIP_FILE_NAME;
    }

    public CompletableFuture<Topology> getTopology() {
        return this.commandContext.runAsync(future -> {
            Topology topology = new Topology();
            this.peers.update(this.peer);
            for (Peer peer : this.peers) {
                if (PeerState.ALIVE != peer.state()) continue;
                SocketAddress clientEndpoint = peer.clientEndpoint();
                ((BrokerAddress)topology.brokers().add()).setHost((DirectBuffer)clientEndpoint.getHostBuffer(), 0, clientEndpoint.hostLength()).setPort(clientEndpoint.port());
                for (RaftMembership raftMembership : peer.raftMemberships()) {
                    if (RaftMembershipState.LEADER != raftMembership.state()) continue;
                    DirectBuffer topicName = BufferUtil.cloneBuffer((DirectBuffer)raftMembership.topicNameBuffer(), (int)0, (int)raftMembership.topicNameLength());
                    ((TopicLeader)((Object)((Object)topology.topicLeaders().add()))).setTopicName(topicName, 0, topicName.capacity()).setPartitionId(raftMembership.partitionId()).setHost((DirectBuffer)clientEndpoint.getHostBuffer(), 0, clientEndpoint.hostLength()).setPort(clientEndpoint.port());
                }
            }
            future.complete(topology);
        });
    }
}

