/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.data;

public class Heartbeat
implements Comparable<Heartbeat> {
    protected long generation;
    protected int version;

    public long generation() {
        return this.generation;
    }

    public Heartbeat generation(long generation) {
        this.generation = generation;
        return this;
    }

    public int version() {
        return this.version;
    }

    public Heartbeat version(int version) {
        this.version = version;
        return this;
    }

    public void wrap(Heartbeat heartbeat) {
        this.generation(heartbeat.generation()).version(heartbeat.version());
    }

    @Override
    public int compareTo(Heartbeat o) {
        int cmp = Long.compare(this.generation(), o.generation());
        if (cmp == 0) {
            cmp = Long.compare(this.version(), o.version());
        }
        return cmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Heartbeat heartbeat = (Heartbeat)o;
        if (this.generation != heartbeat.generation) {
            return false;
        }
        return this.version == heartbeat.version;
    }

    public int hashCode() {
        int result = (int)(this.generation ^ this.generation >>> 32);
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "Heartbeat{generation=" + this.generation + ", version=" + this.version + '}';
    }
}

