/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.data;

import io.zeebe.broker.clustering.gossip.data.Heartbeat;
import io.zeebe.broker.clustering.gossip.data.RaftMembership;
import io.zeebe.broker.clustering.gossip.data.RaftMembershipList;
import io.zeebe.clustering.gossip.EndpointType;
import io.zeebe.clustering.gossip.PeerDescriptorDecoder;
import io.zeebe.clustering.gossip.PeerDescriptorEncoder;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.raft.Raft;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class Peer
implements BufferWriter,
BufferReader,
Comparable<Peer> {
    public static final int PEER_ENDPOINT_COUNT = 3;
    public static final int MAX_PEER_LENGTH = 19 + PeerDescriptorEncoder.EndpointsEncoder.sbeHeaderSize() + 3 * (PeerDescriptorEncoder.EndpointsEncoder.sbeBlockLength() + PeerDescriptorEncoder.EndpointsEncoder.hostHeaderLength() + 128) + PeerDescriptorEncoder.RaftMembershipsEncoder.sbeHeaderSize() + 20 * (PeerDescriptorEncoder.RaftMembershipsEncoder.sbeBlockLength() + PeerDescriptorEncoder.RaftMembershipsEncoder.topicNameHeaderLength() + 128);
    protected final PeerDescriptorDecoder decoder = new PeerDescriptorDecoder();
    protected final PeerDescriptorEncoder encoder = new PeerDescriptorEncoder();
    protected final SocketAddress clientEndpoint = new SocketAddress();
    protected final SocketAddress managementEndpoint = new SocketAddress();
    protected final SocketAddress replicationEndpoint = new SocketAddress();
    protected final Heartbeat heartbeat = new Heartbeat();
    protected final RaftMembershipList raftMemberships = new RaftMembershipList();
    protected PeerState state = PeerState.NULL_VAL;
    protected long changeStateTime = -1L;

    public SocketAddress clientEndpoint() {
        return this.clientEndpoint;
    }

    public SocketAddress managementEndpoint() {
        return this.managementEndpoint;
    }

    public SocketAddress replicationEndpoint() {
        return this.replicationEndpoint;
    }

    public Heartbeat heartbeat() {
        return this.heartbeat;
    }

    public PeerState state() {
        return this.state;
    }

    public Peer state(PeerState state) {
        this.state = state;
        return this;
    }

    public RaftMembershipList raftMemberships() {
        return this.raftMemberships;
    }

    public Peer raftMemberships(RaftMembershipList raftMemberships) {
        this.raftMemberships.clear();
        for (RaftMembership raftMembership : raftMemberships) {
            this.raftMemberships.add(raftMembership);
        }
        return this;
    }

    public long changeStateTime() {
        return this.changeStateTime;
    }

    public Peer changeStateTime(long changeStateTime) {
        this.changeStateTime = changeStateTime;
        return this;
    }

    public Peer alive() {
        if (this.state != PeerState.ALIVE) {
            this.state = PeerState.ALIVE;
            this.changeStateTime = System.currentTimeMillis();
        }
        return this;
    }

    public Peer suspect() {
        if (this.state != PeerState.SUSPECT) {
            this.state = PeerState.SUSPECT;
            this.changeStateTime = System.currentTimeMillis();
        }
        return this;
    }

    public Peer dead() {
        if (this.state != PeerState.DEAD) {
            this.state = PeerState.DEAD;
            this.changeStateTime = System.currentTimeMillis();
        }
        return this;
    }

    @Override
    public int compareTo(Peer o) {
        return this.managementEndpoint.compareTo(o.managementEndpoint());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int frameEnd = offset + length;
        this.reset();
        this.decoder.wrap(buffer, offset, 19, 1);
        this.state(this.decoder.state()).changeStateTime(this.decoder.changeStateTime());
        this.heartbeat().generation(this.decoder.generation()).version(this.decoder.version());
        for (PeerDescriptorDecoder.EndpointsDecoder endpointsDecoder : this.decoder.endpoints()) {
            SocketAddress endpoint;
            switch (endpointsDecoder.endpointType()) {
                case CLIENT: {
                    endpoint = this.clientEndpoint();
                    break;
                }
                case MANAGEMENT: {
                    endpoint = this.managementEndpoint();
                    break;
                }
                case REPLICATION: {
                    endpoint = this.replicationEndpoint();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown endpoint type for peer: " + (Object)((Object)endpointsDecoder.endpointType()));
                }
            }
            MutableDirectBuffer hostBuffer = endpoint.getHostBuffer();
            int hostLength = endpointsDecoder.hostLength();
            endpoint.port(endpointsDecoder.port());
            endpoint.hostLength(hostLength);
            endpointsDecoder.getHost(hostBuffer, 0, hostLength);
        }
        for (PeerDescriptorDecoder.RaftMembershipsDecoder raftMembershipsDecoder : this.decoder.raftMemberships()) {
            this.raftMemberships.add(raftMembershipsDecoder);
        }
        assert (this.decoder.limit() == frameEnd) : "Decoder read only to position " + this.decoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public void wrap(Peer peer) {
        this.heartbeat().wrap(peer.heartbeat());
        this.clientEndpoint().wrap(peer.clientEndpoint());
        this.managementEndpoint().wrap(peer.managementEndpoint());
        this.replicationEndpoint().wrap(peer.replicationEndpoint());
        this.raftMemberships(peer.raftMemberships());
        this.state(peer.state()).changeStateTime(peer.changeStateTime());
    }

    public int getLength() {
        int length = this.encoder.sbeBlockLength() + PeerDescriptorDecoder.EndpointsDecoder.sbeHeaderSize() + 3 * (PeerDescriptorDecoder.EndpointsDecoder.sbeBlockLength() + PeerDescriptorDecoder.EndpointsDecoder.hostHeaderLength()) + this.clientEndpoint().hostLength() + this.managementEndpoint().hostLength() + this.replicationEndpoint().hostLength() + PeerDescriptorDecoder.RaftMembershipsDecoder.sbeHeaderSize();
        for (RaftMembership raftMembership : this.raftMemberships()) {
            length += PeerDescriptorDecoder.RaftMembershipsDecoder.sbeBlockLength() + PeerDescriptorDecoder.RaftMembershipsDecoder.topicNameHeaderLength() + raftMembership.topicNameLength();
        }
        return length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        Heartbeat heartbeat = this.heartbeat();
        SocketAddress clientEndpoint = this.clientEndpoint();
        SocketAddress managementEndpoint = this.managementEndpoint();
        SocketAddress replicationEndpoint = this.replicationEndpoint();
        MutableDirectBuffer clientEndpointBuffer = clientEndpoint.getHostBuffer();
        int clientHostLength = clientEndpoint.hostLength();
        MutableDirectBuffer managementEndpointBuffer = managementEndpoint.getHostBuffer();
        int managementHostLength = managementEndpoint.hostLength();
        MutableDirectBuffer replicationEndpointBuffer = replicationEndpoint.getHostBuffer();
        int replicationHostLength = replicationEndpoint.hostLength();
        PeerDescriptorEncoder.EndpointsEncoder endpointsEncoder = this.encoder.wrap(buffer, offset).state(this.state()).generation(heartbeat.generation()).version(heartbeat.version()).changeStateTime(this.changeStateTime()).endpointsCount(3);
        endpointsEncoder.next().endpointType(EndpointType.CLIENT).port(clientEndpoint.port()).putHost((DirectBuffer)clientEndpointBuffer, 0, clientHostLength);
        endpointsEncoder.next().endpointType(EndpointType.MANAGEMENT).port(managementEndpoint.port()).putHost((DirectBuffer)managementEndpointBuffer, 0, managementHostLength);
        endpointsEncoder.next().endpointType(EndpointType.REPLICATION).port(replicationEndpoint.port()).putHost((DirectBuffer)replicationEndpointBuffer, 0, replicationHostLength);
        PeerDescriptorEncoder.RaftMembershipsEncoder raftMembershipsEncoder = this.encoder.raftMembershipsCount(this.raftMemberships.size());
        for (RaftMembership raftMembership : this.raftMemberships) {
            raftMembershipsEncoder.next().partitionId(raftMembership.partitionId()).term(raftMembership.term()).state(raftMembership.state()).putTopicName(raftMembership.topicNameBuffer(), 0, raftMembership.topicNameLength());
        }
    }

    public void reset() {
        this.heartbeat().generation(PeerDescriptorEncoder.generationNullValue());
        this.heartbeat().version(PeerDescriptorEncoder.versionNullValue());
        this.clientEndpoint().reset();
        this.clientEndpoint().port(PeerDescriptorDecoder.EndpointsDecoder.portNullValue());
        this.managementEndpoint().reset();
        this.managementEndpoint().port(PeerDescriptorDecoder.EndpointsDecoder.portNullValue());
        this.replicationEndpoint().reset();
        this.replicationEndpoint().port(PeerDescriptorDecoder.EndpointsDecoder.portNullValue());
        this.raftMemberships.clear();
        this.state = PeerState.NULL_VAL;
        this.changeStateTime = -1L;
    }

    public void addRaft(Raft raft) {
        this.raftMemberships().add(raft);
    }

    public void removeRaft(Raft raft) {
        this.raftMemberships().remove(raft);
    }

    public String toString() {
        return "Peer{clientEndpoint=" + this.clientEndpoint + ", managementEndpoint=" + this.managementEndpoint + ", replicationEndpoint=" + this.replicationEndpoint + ", heartbeat=" + this.heartbeat + ", raftMembershipList=" + this.raftMemberships + ", state=" + (Object)((Object)this.state) + ", changeStateTime=" + this.changeStateTime + '}';
    }
}

