/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.data;

import io.zeebe.broker.clustering.gossip.data.Heartbeat;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerListIterator;
import io.zeebe.broker.clustering.gossip.data.PeerListListener;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.util.CloseableSilently;
import io.zeebe.util.allocation.BufferAllocator;
import io.zeebe.util.allocation.DirectBufferAllocator;
import io.zeebe.util.collection.CompactList;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PeerList
implements Iterable<Peer>,
CloseableSilently {
    protected static final Comparator<DirectBuffer> PEER_COMPARATOR = new Comparator<DirectBuffer>(){
        protected final Peer peer1 = new Peer();
        protected final Peer peer2 = new Peer();

        @Override
        public int compare(DirectBuffer o1, DirectBuffer o2) {
            this.peer1.wrap(o1, 0, o1.capacity());
            this.peer2.wrap(o2, 0, o2.capacity());
            return this.peer1.compareTo(this.peer2);
        }
    };
    protected final CompactList underlyingList;
    protected final PeerListIterator iterator;
    protected final PeerListIterator localIterator;
    protected final UnsafeBuffer tmpPeerBuffer = new UnsafeBuffer(new byte[Peer.MAX_PEER_LENGTH]);
    protected final UnsafeBuffer tmpPeerBufferView = new UnsafeBuffer(0L, 0);
    protected final Peer shuffledPeer = new Peer();
    protected final Random shuffleRandom = new Random();
    protected final List<PeerListListener> listeners = new CopyOnWriteArrayList<PeerListListener>();

    public PeerList(int capacity) {
        this(new CompactList(Peer.MAX_PEER_LENGTH, capacity, (BufferAllocator)new DirectBufferAllocator()));
    }

    public PeerList(CompactList underlyingList) {
        this.underlyingList = underlyingList;
        this.iterator = new PeerListIterator(this);
        this.localIterator = new PeerListIterator(this);
    }

    public CompactList getPeers() {
        return this.underlyingList;
    }

    public void merge(Iterator<Peer> updates) {
        this.merge(updates, null);
    }

    public void merge(Iterator<Peer> updates, PeerList diff) {
        this.localIterator.reset();
        if (this.localIterator.hasNext()) {
            Peer thatPeer = updates.hasNext() ? updates.next() : null;
            boolean keepPosition = false;
            Peer thisPeer = null;
            do {
                thisPeer = !keepPosition ? this.localIterator.next() : thisPeer;
                keepPosition = false;
                int cmp = -1;
                if (thatPeer != null) {
                    cmp = thisPeer.compareTo(thatPeer);
                }
                if (cmp < 0) {
                    if (diff != null) {
                        diff.append(thisPeer);
                    }
                    if (this.localIterator.hasNext() || thatPeer == null) continue;
                    this.append(thatPeer);
                    continue;
                }
                if (cmp > 0) {
                    if (thatPeer.state() == PeerState.ALIVE) {
                        this.add(this.localIterator.position(), thatPeer);
                    } else {
                        keepPosition = true;
                    }
                    thatPeer = updates.hasNext() ? updates.next() : null;
                    continue;
                }
                if (this.mergePeer(thisPeer, thatPeer, this.localIterator.position()) && diff != null) {
                    diff.append(thisPeer);
                }
                thatPeer = this.localIterator.hasNext() && updates.hasNext() ? updates.next() : null;
            } while (this.localIterator.hasNext());
        }
        while (updates.hasNext()) {
            Peer peer = updates.next();
            this.append(peer);
        }
    }

    protected boolean mergePeer(Peer thisPeer, Peer thatPeer, int idx) {
        Heartbeat thatHeartbeat;
        Heartbeat thisHeartbeat = thisPeer.heartbeat();
        int cmp = thisHeartbeat.compareTo(thatHeartbeat = thatPeer.heartbeat());
        if (cmp < 0) {
            thisPeer.clientEndpoint().wrap(thatPeer.clientEndpoint());
            thisPeer.managementEndpoint().wrap(thatPeer.managementEndpoint());
            thisPeer.replicationEndpoint().wrap(thatPeer.replicationEndpoint());
            thisPeer.raftMemberships(thatPeer.raftMemberships());
        }
        switch (thatPeer.state()) {
            case ALIVE: {
                if (cmp >= 0) break;
                thisHeartbeat.wrap(thatHeartbeat);
                thisPeer.alive();
                this.set(idx, thisPeer);
                break;
            }
            case SUSPECT: {
                if (thisPeer.state() == PeerState.SUSPECT && cmp < 0) {
                    thisHeartbeat.wrap(thatHeartbeat);
                    this.set(idx, thisPeer);
                    break;
                }
                if (thisPeer.state() != PeerState.ALIVE || cmp > 0) break;
                thisHeartbeat.wrap(thatHeartbeat);
                thisPeer.suspect();
                this.set(idx, thisPeer);
                break;
            }
            case DEAD: {
                if (cmp > 0) break;
                thisHeartbeat.wrap(thatHeartbeat);
                thisPeer.dead();
                this.set(idx, thisPeer);
                break;
            }
            default: {
                if (cmp >= 0) break;
                this.set(idx, thisPeer);
            }
        }
        return cmp > 0;
    }

    public void get(int idx, Peer dst) {
        int length = this.underlyingList.get(idx, (MutableDirectBuffer)this.tmpPeerBuffer, 0);
        dst.wrap((DirectBuffer)this.tmpPeerBuffer, 0, length);
    }

    public void set(int idx, Peer src) {
        src.write((MutableDirectBuffer)this.tmpPeerBuffer, 0);
        this.underlyingList.set(idx, (DirectBuffer)this.tmpPeerBuffer, 0, src.getLength());
    }

    public void add(int idx, Peer peer) {
        peer.write((MutableDirectBuffer)this.tmpPeerBuffer, 0);
        this.underlyingList.add((DirectBuffer)this.tmpPeerBuffer, 0, peer.getLength(), idx);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onPeerJoin(peer);
        }
    }

    public void append(Peer peer) {
        this.add(this.size(), peer);
    }

    public void insert(Peer peer) {
        int idx = this.find(peer);
        if (idx < 0) {
            this.add(~idx, peer);
        }
    }

    public void update(Peer peer) {
        int idx = this.find(peer);
        if (idx > -1) {
            this.set(idx, peer);
        }
    }

    public int find(Peer peer) {
        peer.write((MutableDirectBuffer)this.tmpPeerBuffer, 0);
        this.tmpPeerBufferView.wrap((DirectBuffer)this.tmpPeerBuffer, 0, peer.getLength());
        int index = this.underlyingList.find((DirectBuffer)this.tmpPeerBufferView, PEER_COMPARATOR);
        this.tmpPeerBufferView.wrap(0L, 0);
        return index;
    }

    public void clear() {
        this.underlyingList.clear();
    }

    public int size() {
        return this.underlyingList.size();
    }

    public int sizeVolatile() {
        return this.underlyingList.sizeVolatile();
    }

    public int capacity() {
        return this.underlyingList.capacity();
    }

    public void shuffle() {
        int size;
        for (int i = size = this.size(); i > 1; --i) {
            this.swap(i - 1, this.shuffleRandom.nextInt(i));
        }
    }

    public void swap(int i, int j) {
        this.get(i, this.shuffledPeer);
        int length = this.underlyingList.get(j, (MutableDirectBuffer)this.tmpPeerBuffer, 0);
        this.underlyingList.set(i, (DirectBuffer)this.tmpPeerBuffer, 0, length);
        this.shuffledPeer.write((MutableDirectBuffer)this.tmpPeerBuffer, 0);
        this.underlyingList.set(j, (DirectBuffer)this.tmpPeerBuffer, 0, this.shuffledPeer.getLength());
    }

    public void addAll(PeerList peerList) {
        PeerListIterator iterator = peerList.iterator();
        while (iterator.hasNext()) {
            this.append(iterator.next());
        }
    }

    public PeerListIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public InputStream toInputStream() {
        return this.underlyingList.toInputStream();
    }

    public void registerListener(PeerListListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PeerListListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "PeerList{size=" + this.underlyingList.size() + ", elements=" + StreamSupport.stream(this.spliterator(), false).map(Peer::toString).collect(Collectors.joining(", ", "[", "]")) + '}';
    }

    public void close() {
        this.underlyingList.close();
    }
}

