/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.data;

import io.zeebe.clustering.gossip.PeerDescriptorDecoder;
import io.zeebe.clustering.gossip.RaftMembershipState;
import io.zeebe.raft.Raft;
import io.zeebe.util.StringUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RaftMembership {
    private Raft reference;
    private int partitionId = PeerDescriptorDecoder.RaftMembershipsDecoder.partitionIdNullValue();
    private int term = PeerDescriptorDecoder.RaftMembershipsDecoder.termNullValue();
    private RaftMembershipState state = RaftMembershipState.NULL_VAL;
    private int topicNameLength = 0;
    private final MutableDirectBuffer topicNameBuffer = new UnsafeBuffer(new byte[128]);

    public RaftMembership reference(Raft reference) {
        this.reference = reference;
        return this;
    }

    public int partitionId() {
        if (this.reference != null) {
            return this.reference.getLogStream().getPartitionId();
        }
        return this.partitionId;
    }

    public RaftMembership partitionId(int partitionId) {
        if (this.reference != null) {
            throw new IllegalArgumentException("Cannot set partition id on reference");
        }
        this.partitionId = partitionId;
        return this;
    }

    public int term() {
        if (this.reference != null) {
            return this.reference.getTerm();
        }
        return this.term;
    }

    public RaftMembership term(int term) {
        if (this.reference != null) {
            throw new IllegalArgumentException("Cannot set term on reference");
        }
        this.term = term;
        return this;
    }

    public RaftMembershipState state() {
        if (this.reference != null) {
            switch (this.reference.getState()) {
                case FOLLOWER: {
                    return RaftMembershipState.FOLLOWER;
                }
                case CANDIDATE: {
                    return RaftMembershipState.CANDIDATE;
                }
                case LEADER: {
                    return RaftMembershipState.LEADER;
                }
            }
            return RaftMembershipState.SBE_UNKNOWN;
        }
        return this.state;
    }

    public RaftMembership state(RaftMembershipState state) {
        if (this.reference != null) {
            throw new IllegalArgumentException("Cannot set state on reference");
        }
        this.state = state;
        return this;
    }

    public DirectBuffer topicNameBuffer() {
        if (this.reference != null) {
            return this.reference.getLogStream().getTopicName();
        }
        return this.topicNameBuffer;
    }

    public MutableDirectBuffer topicNameMutableBuffer() {
        if (this.reference != null) {
            throw new IllegalArgumentException("Cannot get mutable topic name buffer from reference");
        }
        return this.topicNameBuffer;
    }

    public String topicName() {
        int length = this.topicNameLength();
        byte[] tmp = new byte[length];
        this.topicNameBuffer().getBytes(0, tmp, 0, length);
        return StringUtil.fromBytes((byte[])tmp);
    }

    public RaftMembership topicName(DirectBuffer src, int offset, int length) {
        this.checkTopicNameLength(length);
        this.topicNameBuffer.putBytes(0, src, offset, length);
        this.topicNameBuffer.setMemory(length, this.topicNameBuffer.capacity() - length, (byte)0);
        this.topicNameLength = length;
        return this;
    }

    public int topicNameLength() {
        if (this.reference != null) {
            return this.reference.getLogStream().getTopicName().capacity();
        }
        return this.topicNameLength;
    }

    public RaftMembership topicNameLength(int topicNameLength) {
        if (this.reference != null) {
            throw new IllegalArgumentException("Cannot set topic name on reference");
        }
        this.checkTopicNameLength(topicNameLength);
        this.topicNameLength = topicNameLength;
        return this;
    }

    private void checkTopicNameLength(int length) {
        if (length > this.topicNameBuffer.capacity()) {
            throw new RuntimeException(String.format("Topic name length exceeds max length (%d > %d bytes)", length, this.topicNameBuffer.capacity()));
        }
    }

    public void wrap(RaftMembership other) {
        this.reset();
        if (other.reference != null) {
            this.reference = other.reference;
        } else {
            this.topicNameBuffer.getBytes(0, other.topicNameBuffer, 0, other.topicNameLength);
            this.topicNameLength = other.topicNameLength;
            this.partitionId = other.partitionId;
            this.term = other.term;
            this.state = other.state;
        }
    }

    public RaftMembership reset() {
        this.reference = null;
        this.partitionId = PeerDescriptorDecoder.RaftMembershipsDecoder.partitionIdNullValue();
        this.term = PeerDescriptorDecoder.RaftMembershipsDecoder.termNullValue();
        this.state = RaftMembershipState.NULL_VAL;
        this.topicNameLength = 0;
        this.topicNameBuffer.setMemory(0, this.topicNameBuffer.capacity(), (byte)0);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftMembership that = (RaftMembership)o;
        if (this.partitionId() != that.partitionId()) {
            return false;
        }
        if (this.term() != that.term()) {
            return false;
        }
        if (this.state() != that.state()) {
            return false;
        }
        return this.topicNameBuffer() != null ? this.topicNameBuffer().equals(that.topicNameBuffer()) : that.topicNameBuffer() == null;
    }

    public int hashCode() {
        int result = this.partitionId();
        result = 31 * result + this.term();
        result = 31 * result + (this.state() != null ? this.state().hashCode() : 0);
        result = 31 * result + (this.topicNameBuffer() != null ? this.topicNameBuffer().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RaftMembership{partitionId=" + this.partitionId() + ", term=" + this.term() + ", state=" + (Object)((Object)this.state()) + ", topicName=" + this.topicName() + ", reference=" + this.reference + '}';
    }
}

