/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.data;

import io.zeebe.broker.clustering.gossip.data.RaftMembership;
import io.zeebe.broker.clustering.gossip.data.RaftMembershipIterator;
import io.zeebe.clustering.gossip.GossipDecoder;
import io.zeebe.clustering.gossip.PeerDescriptorDecoder;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.raft.Raft;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;

public class RaftMembershipList
implements Iterable<RaftMembership> {
    public static final int MAX_RAFT_MEMBERS = 20;
    protected final RaftMembership[] elements = new RaftMembership[20];
    protected final RaftMembershipIterator iterator = new RaftMembershipIterator(this);
    protected int size = 0;

    public RaftMembershipList() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = new RaftMembership();
        }
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    public RaftMembership get(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    public RaftMembershipList clear() {
        this.iterator.reset();
        this.size = 0;
        for (RaftMembership value : this.elements) {
            value.reset();
        }
        return this;
    }

    @Override
    public Iterator<RaftMembership> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public RaftMembershipList add(RaftMembership raftMembership) {
        this.checkCapacity();
        this.elements[this.size].reset().partitionId(raftMembership.partitionId()).term(raftMembership.term()).state(raftMembership.state()).topicName(raftMembership.topicNameBuffer(), 0, raftMembership.topicNameLength());
        ++this.size;
        return this;
    }

    public RaftMembershipList add(Raft raft) {
        this.checkCapacity();
        this.elements[this.size].reset().reference(raft);
        ++this.size;
        return this;
    }

    public RaftMembershipList add(PeerDescriptorDecoder.RaftMembershipsDecoder decoder) {
        this.checkCapacity();
        RaftMembership element = this.elements[this.size];
        element.reset().partitionId(decoder.partitionId()).term(decoder.term()).state(decoder.state());
        int topicNameLength = decoder.topicNameLength();
        element.topicNameLength(topicNameLength);
        decoder.getTopicName(element.topicNameMutableBuffer(), 0, topicNameLength);
        ++this.size;
        return this;
    }

    public RaftMembershipList add(GossipDecoder.PeersDecoder.RaftMembershipsDecoder decoder) {
        this.checkCapacity();
        RaftMembership element = this.elements[this.size];
        element.reset().partitionId(decoder.partitionId()).term(decoder.term()).state(decoder.state());
        int topicNameLength = decoder.topicNameLength();
        element.topicNameLength(topicNameLength);
        decoder.getTopicName(element.topicNameMutableBuffer(), 0, topicNameLength);
        ++this.size;
        return this;
    }

    public RaftMembershipList remove(Raft raft) {
        LogStream stream = raft.getLogStream();
        DirectBuffer topicName = stream.getTopicName();
        int partitionId = stream.getPartitionId();
        for (int i = 0; i < this.size; ++i) {
            RaftMembership element = this.elements[i];
            if (!topicName.equals(element.topicNameBuffer()) || partitionId != element.partitionId()) continue;
            this.remove(i);
            break;
        }
        return this;
    }

    private void remove(int index) {
        this.checkIndex(index);
        --this.size;
        this.elements[index].wrap(this.elements[this.size]);
        this.elements[this.size].reset();
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, this.size));
        }
    }

    private void checkCapacity() {
        if (this.size() >= this.capacity()) {
            throw new IllegalArgumentException(String.format("Unable to add element to a full list of capacity %d", this.capacity()));
        }
    }

    public String toString() {
        return "RaftMembershipList{size=" + this.size() + ", elements=" + StreamSupport.stream(this.spliterator(), false).map(RaftMembership::toString).collect(Collectors.joining(", ", "[", "]")) + '}';
    }
}

