/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.handler;

import io.zeebe.broker.clustering.gossip.protocol.GossipController;
import io.zeebe.clustering.gossip.MessageHeaderDecoder;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import org.agrona.DirectBuffer;

public class GossipFragmentHandler
implements ServerMessageHandler,
ServerRequestHandler {
    protected final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final GossipController gossipController;

    public GossipFragmentHandler(GossipController gossipController) {
        this.gossipController = gossipController;
    }

    public boolean onRequest(ServerOutput output, RemoteAddress remoteAddress, DirectBuffer buffer, int offset, int length, long requestId) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (3 == schemaId) {
            int templateId = this.messageHeaderDecoder.templateId();
            switch (templateId) {
                case 0: {
                    return this.gossipController.onGossipRequest(buffer, offset, length, output, remoteAddress, requestId);
                }
                case 1: {
                    return this.gossipController.onProbeRequest(buffer, offset, length, output, remoteAddress, requestId);
                }
            }
            return true;
        }
        return true;
    }

    public boolean onMessage(ServerOutput output, RemoteAddress remoteAddress, DirectBuffer buffer, int offset, int length) {
        return true;
    }
}

