/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.message;

import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.message.util.GossipMessageReader;
import io.zeebe.broker.clustering.gossip.message.util.GossipMessageWriter;
import io.zeebe.clustering.gossip.GossipEncoder;
import io.zeebe.clustering.gossip.MessageHeaderDecoder;
import io.zeebe.clustering.gossip.MessageHeaderEncoder;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import java.util.Iterator;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class GossipResponse
implements BufferReader,
BufferWriter {
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final GossipEncoder bodyEncoder = new GossipEncoder();
    private final GossipMessageReader gossipReader = new GossipMessageReader();
    private final GossipMessageWriter gossipWriter = new GossipMessageWriter();

    public Iterator<Peer> peers() {
        return this.gossipReader;
    }

    public GossipResponse peers(PeerList peers) {
        this.gossipWriter.peers(peers);
        return this;
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.gossipWriter.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.gossipWriter.write(buffer, offset += this.headerEncoder.encodedLength());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.headerDecoder.wrap(buffer, offset);
        this.gossipReader.wrap(buffer, offset += this.headerDecoder.encodedLength(), length -= this.headerDecoder.encodedLength());
    }
}

