/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.message;

import io.zeebe.clustering.gossip.MessageHeaderDecoder;
import io.zeebe.clustering.gossip.MessageHeaderEncoder;
import io.zeebe.clustering.gossip.ProbeDecoder;
import io.zeebe.clustering.gossip.ProbeEncoder;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ProbeRequest
implements BufferReader,
BufferWriter {
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected final ProbeDecoder bodyDecoder = new ProbeDecoder();
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final ProbeEncoder bodyEncoder = new ProbeEncoder();
    protected final SocketAddress target = new SocketAddress();

    public SocketAddress target() {
        return this.target;
    }

    public ProbeRequest target(SocketAddress target) {
        this.target.wrap(target);
        return this;
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength() + ProbeEncoder.hostHeaderLength() + this.target.hostLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).port(this.target.port()).putHost((DirectBuffer)this.target.getHostBuffer(), 0, this.target.hostLength());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        int hostLength = this.bodyDecoder.hostLength();
        this.target.port(this.bodyDecoder.port());
        this.target.hostLength(hostLength);
        this.bodyDecoder.getHost(this.target.getHostBuffer(), 0, hostLength);
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public void reset() {
        this.target.reset();
    }
}

